/* $NetBSD: rump_sunos_syscallargs.h,v 1.2 2013/05/15 21:41:25 pooka Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.2 2013/05/15 21:39:30 pooka Exp
 */

#ifndef _RUMP_SUNOS_SYS_SYSCALLARGS_H_
#define	_RUMP_SUNOS_SYS_SYSCALLARGS_H_

#define	RUMP_SUNOS_SYS_MAXSYSARGS	8

#undef	syscallarg
#define	syscallarg(x)							\
	union {								\
		register_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register_t) < sizeof (x))	\
				? 0					\
				: sizeof (register_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

#undef check_syscall_args
#define check_syscall_args(call) /*LINTED*/ \
	typedef char call##_check_args[sizeof (struct call##_args) \
		<= RUMP_SUNOS_SYS_MAXSYSARGS * sizeof (register_t) ? 1 : -1];

struct sys_read_args;

struct sys_write_args;

struct rump_sunos_sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(int) mode;
};
check_syscall_args(rump_sunos_sys_open)

struct sys_close_args;

struct sys_link_args;

struct sys_unlink_args;

struct sys_chdir_args;

struct sys_fchdir_args;

struct sys_chmod_args;

struct sys_chown_args;

struct sys_setuid_args;

struct sys_access_args;

struct sys_dup_args;

struct sys_symlink_args;

struct sys_readlink_args;

struct sys_umask_args;

struct sys_chroot_args;

struct sys_getgroups_args;

struct sys_setgroups_args;

struct sys_setpgid_args;

struct sys_dup2_args;

struct sys_fsync_args;

struct sys_readv_args;

struct sys_writev_args;

struct sys_fchown_args;

struct sys_fchmod_args;

struct sys_setreuid_args;

struct sys_setregid_args;

struct sys_rename_args;

struct sys_flock_args;

struct sys_sendto_args;

struct sys_shutdown_args;

struct sys_mkdir_args;

struct sys_rmdir_args;

struct sys_pread_args;

struct sys_pwrite_args;

struct sys_setgid_args;

struct sys_setegid_args;

struct sys_seteuid_args;

struct sys_lseek_args;

struct sys_truncate_args;

struct sys_ftruncate_args;

struct sys_getpgid_args;

struct sys_poll_args;

struct sys_getsid_args;

struct sys___getcwd_args;

struct sys_fchroot_args;

struct rump_sunos_sys_getdents_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(size_t) nbytes;
};
check_syscall_args(rump_sunos_sys_getdents)

struct compat_50_sys_utimes_args;

struct compat_50_sys_futimes_args;

struct rump_sunos_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct sunos_stat *) sp;
};
check_syscall_args(rump_sunos_sys_stat)

struct rump_sunos_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct sunos_stat *) sp;
};
check_syscall_args(rump_sunos_sys_fstat)

struct rump_sunos_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct sunos_stat *) sp;
};
check_syscall_args(rump_sunos_sys_lstat)

struct sys___mknod50_args;

/*
 * System call prototypes.
 */

int	sys_nosys(struct lwp *, const void *, register_t *);

int	sys_read(struct lwp *, const struct sys_read_args *, register_t *);

int	sys_write(struct lwp *, const struct sys_write_args *, register_t *);

int	rump_sunos_sys_open(struct lwp *, const struct rump_sunos_sys_open_args *, register_t *);

int	sys_close(struct lwp *, const struct sys_close_args *, register_t *);

int	sys_link(struct lwp *, const struct sys_link_args *, register_t *);

int	sys_unlink(struct lwp *, const struct sys_unlink_args *, register_t *);

int	sys_chdir(struct lwp *, const struct sys_chdir_args *, register_t *);

int	sys_fchdir(struct lwp *, const struct sys_fchdir_args *, register_t *);

int	sys_chmod(struct lwp *, const struct sys_chmod_args *, register_t *);

int	sys_chown(struct lwp *, const struct sys_chown_args *, register_t *);

int	sys_getpid_with_ppid(struct lwp *, const void *, register_t *);

int	sys_setuid(struct lwp *, const struct sys_setuid_args *, register_t *);

int	sys_getuid_with_euid(struct lwp *, const void *, register_t *);

int	sys_geteuid(struct lwp *, const void *, register_t *);

int	sys_access(struct lwp *, const struct sys_access_args *, register_t *);

int	sys_sync(struct lwp *, const void *, register_t *);

int	sys_dup(struct lwp *, const struct sys_dup_args *, register_t *);

int	sys_pipe(struct lwp *, const void *, register_t *);

int	sys_getgid_with_egid(struct lwp *, const void *, register_t *);

int	sys_symlink(struct lwp *, const struct sys_symlink_args *, register_t *);

int	sys_readlink(struct lwp *, const struct sys_readlink_args *, register_t *);

int	sys_umask(struct lwp *, const struct sys_umask_args *, register_t *);

int	sys_chroot(struct lwp *, const struct sys_chroot_args *, register_t *);

int	sys_getgroups(struct lwp *, const struct sys_getgroups_args *, register_t *);

int	sys_setgroups(struct lwp *, const struct sys_setgroups_args *, register_t *);

int	sys_getpgrp(struct lwp *, const void *, register_t *);

int	sys_setpgid(struct lwp *, const struct sys_setpgid_args *, register_t *);

int	sys_dup2(struct lwp *, const struct sys_dup2_args *, register_t *);

int	sys_fsync(struct lwp *, const struct sys_fsync_args *, register_t *);

int	sys_readv(struct lwp *, const struct sys_readv_args *, register_t *);

int	sys_writev(struct lwp *, const struct sys_writev_args *, register_t *);

int	sys_fchown(struct lwp *, const struct sys_fchown_args *, register_t *);

int	sys_fchmod(struct lwp *, const struct sys_fchmod_args *, register_t *);

int	sys_setreuid(struct lwp *, const struct sys_setreuid_args *, register_t *);

int	sys_setregid(struct lwp *, const struct sys_setregid_args *, register_t *);

int	sys_rename(struct lwp *, const struct sys_rename_args *, register_t *);

int	sys_flock(struct lwp *, const struct sys_flock_args *, register_t *);

int	sys_sendto(struct lwp *, const struct sys_sendto_args *, register_t *);

int	sys_shutdown(struct lwp *, const struct sys_shutdown_args *, register_t *);

int	sys_mkdir(struct lwp *, const struct sys_mkdir_args *, register_t *);

int	sys_rmdir(struct lwp *, const struct sys_rmdir_args *, register_t *);

int	sys_setsid(struct lwp *, const void *, register_t *);

int	sys_pread(struct lwp *, const struct sys_pread_args *, register_t *);

int	sys_pwrite(struct lwp *, const struct sys_pwrite_args *, register_t *);

int	sys_setgid(struct lwp *, const struct sys_setgid_args *, register_t *);

int	sys_setegid(struct lwp *, const struct sys_setegid_args *, register_t *);

int	sys_seteuid(struct lwp *, const struct sys_seteuid_args *, register_t *);

int	sys_lseek(struct lwp *, const struct sys_lseek_args *, register_t *);

int	sys_truncate(struct lwp *, const struct sys_truncate_args *, register_t *);

int	sys_ftruncate(struct lwp *, const struct sys_ftruncate_args *, register_t *);

int	sys_getpgid(struct lwp *, const struct sys_getpgid_args *, register_t *);

int	sys_poll(struct lwp *, const struct sys_poll_args *, register_t *);

int	sys_getsid(struct lwp *, const struct sys_getsid_args *, register_t *);

int	sys___getcwd(struct lwp *, const struct sys___getcwd_args *, register_t *);

int	sys_fchroot(struct lwp *, const struct sys_fchroot_args *, register_t *);

int	rump_sunos_sys_getdents(struct lwp *, const struct rump_sunos_sys_getdents_args *, register_t *);

int	compat_50_sys_utimes(struct lwp *, const struct compat_50_sys_utimes_args *, register_t *);

int	compat_50_sys_futimes(struct lwp *, const struct compat_50_sys_futimes_args *, register_t *);

int	rump_sunos_sys_stat(struct lwp *, const struct rump_sunos_sys_stat_args *, register_t *);

int	rump_sunos_sys_fstat(struct lwp *, const struct rump_sunos_sys_fstat_args *, register_t *);

int	rump_sunos_sys_lstat(struct lwp *, const struct rump_sunos_sys_lstat_args *, register_t *);

int	sys___mknod50(struct lwp *, const struct sys___mknod50_args *, register_t *);

#endif /* _RUMP_SUNOS_SYS_SYSCALLARGS_H_ */
