/*	$NetBSD: defs.h,v 1.7 2003/08/07 11:17:25 agc Exp $	*/

/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)defs.h	8.1 (Berkeley) 6/6/93
 */
#ifndef DEFS_H_
#define DEFS_H_

#include <sys/types.h>
#include <sys/time.h>

#include "value.h"
#include "ww.h"

void		addwin(ww_t *, char);
int		ccinit(void);
void		ccend(void);
void		ccflush(void);
void		ccreset(void);
void		ccstart(void);
void		closeiwin(ww_t *);
void		closewin(winvars_t *, ww_t *);
void		closewin1(ww_t *);
int		cx_beginbuf(char *, value_t *, int);
int		cx_beginfile(char *);
void		cx_end(void);
void		deletewin(ww_t *);
void		docmd(winvars_t *);
int		doconfig(void);
void		dodefault(winvars_t *);
int		dolongcmd(char *, value_t *, int);
int		dosource(char *);
void		error(const char *, ...);
void		err_end(void);
int		findid(winvars_t *);
ww_t      *findselwin(winvars_t *);
void		front(ww_t *, char);
void		mloop(winvars_t *);
int		more(ww_t *,  char);
void		movewin(ww_t *, int, int);
ww_t      *openwin(winvars_t *, int, int, int, int, int, int, char *, int, int,
			char *, char **);
ww_t      *openiwin(winvars_t *, int, const char *);
void		p_memerror(void);
void		p_start(void);
void		reframe(void);
void		setcmd(winvars_t *, char);
void		setescape(winvars_t *, char *);
int		setlabel(ww_t *, const char *);
void		setselwin(winvars_t *, ww_t *);
void		setterse(winvars_t *, char);
void		setvars(winvars_t *);
void		sizewin(ww_t *, int, int);
void		startwin(ww_t *);
void		stopwin(ww_t *);
int		s_gettok(void);
void		verror(const char *, va_list);
void		waitnl(ww_t *);
int		waitnl1(ww_t *, const char *);

#endif /* !DEFS_H_ */
