#!/bin/sh
: ${1:?usage: "$0" path}
path="$1"
: ${path:?path is empty} # to protect from removing /dev
: ${SETSDIR:?SETSDIR is unset}
: ${SETS:="base base-meta common-base"}
: ${SETS:="base base-meta common-base common-desktop common-xorg gnome gnome-meta kde kde-meta x11 x11-meta"}
ARCH=i386
set -e
mkdir -p "$path"
cd "$path"
for s in ${SETS}; do xzcat "${SETSDIR}/$s-${ARCH}.tar.xz" | gtar -pxf-; done
# /dev is completely different:
rm -rf "$path"/dev/*
cp /dev/MAKEDEV "$path"/dev/MAKEDEV
(cd "$path"/dev && sh MAKEDEV std fd ptm random)
