#!/bin/sh
IMAGE=${HOME}/openSUSE-13.1-DVD-i586.iso

su root -c "sh -x extract-sets.sh ${IMAGE} ${HOME}/sets/opensuse"
su root -c "sh -x extract-rpms.sh ${IMAGE} ${HOME}/sets/opensuse/suse"

JAIL=/usr/jail/suse
SETSDIR=${HOME}/sets/opensuse
SETSDIR=${SETSDIR} su root -c "sh create-root.sh ${JAIL}"
su root -c "sh start-root.sh ${JAIL}"
su root -c "cd ${SETSDIR} && pax -rw suse ${JAIL}/root/"
su root -c "cp config.sh ${JAIL}/root/"
su root -c "chroot ${JAIL} /bin/sh -c 'uname -a'"
su root -c "chroot ${JAIL} /bin/sh -c 'SUSEDIR=/root/suse /bin/sh -x /root/config.sh'"
su root -c "chroot ${JAIL} /bin/sh -c 'cc --version'"

PKGSRCDIR=/usr/pkgsrc
su root -c "mkdir -p ${JAIL}/usr/pkgsrc"
su root -c "mount -t null -o ro ${PKGSRCDIR} ${JAIL}/usr/pkgsrc"
su root -c "chroot ${JAIL} /bin/sh -c 'cd /usr/pkgsrc/bootstrap && sh bootstrap --workdir /tmp/work'"
su root -c "chroot ${JAIL} /bin/sh -c 'cd /usr/pkgsrc/lang/ecl && /usr/pkg/bin/bmake WRKOBJDIR=/tmp DISTDIR=/usr/pkgsrc-data/distfiles PACKAGES=/usr/pkgsrc-data/packages install'"
su root -c "umount ${JAIL}/usr/pkgsrc"

su root -c "sh stop-root.sh ${JAIL}"
