#!/bin/sh
set -e
image="${1:?image not found}" # openSUSE-13.1-DVD-i586.iso
path="${2:-$(pwd)}" # path to a directory to populate

dev=$(mdconfig -a -t vnode "${image}")
mnt=${TMPDIR:-/tmp}/opensuse-dvd.$$
mkdir "${mnt}"
mount -t cd9660 /dev/"${dev}" "${mnt}"
mkdir -p "${path}"
(cd "${mnt}"/suse && pax -vrw \
i586/binutils-[0-9]* \
i586/libasan0-[0-9]* \
i586/libgomp1-[0-9]* \
i586/libitm1-[0-9]* \
i586/libatomic1-[0-9]* \
\
noarch/linux-glibc-devel-[0-9]* \
i586/glibc-devel-[0-9]* \
\
i586/libisl10-[0-9]* \
i586/libcloog-isl4-[0-9]* \
i586/libmpfr4-[0-9]* \
i586/libmpc3-[0-9]* \
i586/cpp48-[0-9]* \
i586/gcc48-[0-9]* \
i586/libstdc++48-devel-[0-9]* \
i586/gcc48-c++-[0-9]* \
\
i586/cpp-[0-9]* \
i586/gcc-[0-9]* \
i586/gcc-c++-[0-9]* \
"${path}")
umount "${mnt}"
rmdir "${mnt}"
mdconfig -d -u "${dev}"
