#include <stdlib.h>
#ifndef lint
#if 0
static char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#else
#if defined(__NetBSD__) && defined(__IDSTRING)
__IDSTRING(yyrcsid, "$NetBSD: skeleton.c,v 1.26 2006/05/24 18:01:43 christos Exp $");
#endif /* __NetBSD__ && __IDSTRING */
#endif /* 0 */
#endif /* lint */
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING (yyerrflag!=0)
#define YYPREFIX "yy"
#line 2 "winprefsyacc.y"
/*
 * Copyright (C) 1994-2000 The XFree86 Project, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE XFREE86 PROJECT BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the XFree86 Project
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * from the XFree86 Project.
 *
 * Authors:     Earle F. Philhower, III
 */
/* $XFree86: $ */

#ifdef HAVE_XWIN_CONFIG_H
#include <xwin-config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "winprefs.h"

/* The following give better error messages in bison at the cost of a few KB */
#define YYERROR_VERBOSE 1

/* The global pref settings */
WINPREFS pref;

/* The working menu */  
static MENUPARSED menu;

/* Functions for parsing the tokens into out structure */
/* Defined at the end section of this file */

static void SetIconDirectory (char *path);
static void SetDefaultIcon (char *fname);
static void SetRootMenu (char *menu);
static void SetDefaultSysMenu (char *menu, int pos);
static void SetTrayIcon (char *fname);

static void OpenMenu(char *menuname);
static void AddMenuLine(char *name, MENUCOMMANDTYPE cmd, char *param);
static void CloseMenu(void);

static void OpenIcons(void);
static void AddIconLine(char *matchstr, char *iconfile);
static void CloseIcons(void);

static void OpenSysMenu(void);
static void AddSysMenuLine(char *matchstr, char *menuname, int pos);
static void CloseSysMenu(void);

static int yyerror (char *s);

extern void ErrorF (const char* /*f*/, ...);
extern char *yytext;
extern int yylex(void);

#line 79 "winprefsyacc.y"
typedef union {
  char *sVal;
  int iVal;
} YYSTYPE;
#line 102 "winprefsyacc.c"
#define NEWLINE 257
#define MENU 258
#define LB 259
#define RB 260
#define ICONDIRECTORY 261
#define DEFAULTICON 262
#define ICONS 263
#define DEFAULTSYSMENU 264
#define SYSMENU 265
#define ROOTMENU 266
#define SEPARATOR 267
#define ATSTART 268
#define ATEND 269
#define EXEC 270
#define ALWAYSONTOP 271
#define DEBUG 272
#define RELOAD 273
#define TRAYICON 274
#define SILENTEXIT 275
#define STRING 276
#define YYERRCODE 256
const short yylhs[] = {                                        -1,
    0,    0,    2,    2,    4,    4,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,   13,   10,   11,    5,
    6,   15,   15,   15,   15,   15,   16,   16,   17,    7,
   18,   19,   19,   20,    8,    1,    1,    1,   21,   22,
   22,   23,    9,   14,   12,
};
const short yylen[] = {                                         2,
    0,    2,    1,    1,    0,    2,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    3,    4,    3,
    3,    3,    4,    5,    5,    4,    1,    2,    0,    7,
    4,    1,    2,    0,    6,    0,    1,    1,    5,    1,
    2,    0,    7,    2,    3,
};
const short yydefred[] = {                                      1,
    0,    3,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    2,    4,    7,    8,    9,   10,   11,   12,
   13,   14,   15,   16,    0,    0,    0,   34,    0,    0,
    0,    0,    0,   44,   29,   21,   20,    0,   37,   38,
    0,   42,   18,   45,   17,    0,    0,    0,   19,    0,
    0,    6,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   33,   35,    0,    0,    0,    0,    0,    0,    0,
    0,   28,   30,    0,    0,   41,   43,   22,    0,    0,
    0,    0,   31,    0,    0,    0,   23,   26,    0,   25,
   24,   39,
};
const short yydgoto[] = {                                       1,
   41,   13,   14,   48,   15,   16,   17,   18,   19,   20,
   21,   22,   23,   24,   59,   60,   46,   54,   55,   38,
   65,   66,   50,
};
const short yysindex[] = {                                      0,
 -255,    0, -260, -258, -250, -229, -239, -221, -234, -232,
 -231, -216,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -213, -210, -209,    0, -235, -208,
 -207, -206, -205,    0,    0,    0,    0, -204,    0,    0,
 -203,    0,    0,    0,    0, -204, -204, -220,    0, -204,
 -262,    0, -219, -220, -202, -217, -197, -246, -262, -199,
 -195,    0,    0, -212, -217, -194, -204, -211, -201, -190,
 -189,    0,    0, -204, -235,    0,    0,    0, -188, -187,
 -204, -204,    0, -186, -204, -204,    0,    0, -204,    0,
    0,    0,
};
const short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -210,    0,
    0,    0,    0,    0,    0,    0,    0, -200,    0,    0,
    0,    0,    0,    0,    0, -244, -245,    0,    0, -200,
    0,    0,    0, -183,    0,    0,    0,    0, -182,    0,
    0,    0,    0,    0, -181,    0, -245,    0,    0,    0,
    0,    0,    0, -247, -210,    0,    0,    0,    0,    0,
 -245, -245,    0,    0, -245, -245,    0,    0, -247,    0,
    0,    0,
};
const short yygindex[] = {                                      0,
  -20,    0,    0,  -46,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    4,    0,    0,   18,    0,
    0,    8,    0,
};
#define YYTABLESIZE 79
const short yytable[] = {                                      51,
   52,    2,    3,   56,   57,    4,    5,    6,    7,    8,
    9,   68,    5,   58,    5,   25,   10,   26,   11,   12,
   78,    5,    5,   69,   70,   27,   71,   83,    5,   28,
    5,    5,   39,   40,   87,   88,   29,   30,   90,   91,
   34,   31,   92,   32,   33,   35,   36,   37,   42,   43,
   44,   45,   47,   49,   84,   53,   61,   63,   64,   67,
   73,   74,   72,   75,   79,   77,   81,   82,   85,   86,
   89,   62,   76,    0,   80,    5,   32,   27,   40,
};
const short yycheck[] = {                                      46,
   47,  257,  258,   50,  267,  261,  262,  263,  264,  265,
  266,  258,  260,  276,  260,  276,  272,  276,  274,  275,
   67,  267,  267,  270,  271,  276,  273,   74,  276,  259,
  276,  276,  268,  269,   81,   82,  276,  259,   85,   86,
  257,  276,   89,  276,  276,  259,  257,  257,  257,  257,
  257,  257,  257,  257,   75,  276,  276,  260,  276,  257,
  260,  257,   59,  276,  276,  260,  257,  257,  257,  257,
  257,   54,   65,   -1,  276,  276,  260,  260,  260,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 276
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"NEWLINE","MENU","LB","RB",
"ICONDIRECTORY","DEFAULTICON","ICONS","DEFAULTSYSMENU","SYSMENU","ROOTMENU",
"SEPARATOR","ATSTART","ATEND","EXEC","ALWAYSONTOP","DEBUG","RELOAD","TRAYICON",
"SILENTEXIT","STRING",
};
const char * const yyrule[] = {
"$accept : input",
"input :",
"input : input line",
"line : NEWLINE",
"line : command",
"newline_or_nada :",
"newline_or_nada : NEWLINE newline_or_nada",
"command : defaulticon",
"command : icondirectory",
"command : menu",
"command : icons",
"command : sysmenu",
"command : rootmenu",
"command : defaultsysmenu",
"command : debug",
"command : trayicon",
"command : silentexit",
"trayicon : TRAYICON STRING NEWLINE",
"rootmenu : ROOTMENU STRING NEWLINE",
"defaultsysmenu : DEFAULTSYSMENU STRING atspot NEWLINE",
"defaulticon : DEFAULTICON STRING NEWLINE",
"icondirectory : ICONDIRECTORY STRING NEWLINE",
"menuline : SEPARATOR NEWLINE newline_or_nada",
"menuline : STRING ALWAYSONTOP NEWLINE newline_or_nada",
"menuline : STRING EXEC STRING NEWLINE newline_or_nada",
"menuline : STRING MENU STRING NEWLINE newline_or_nada",
"menuline : STRING RELOAD NEWLINE newline_or_nada",
"menulist : menuline",
"menulist : menuline menulist",
"$$1 :",
"menu : MENU STRING LB $$1 newline_or_nada menulist RB",
"iconline : STRING STRING NEWLINE newline_or_nada",
"iconlist : iconline",
"iconlist : iconline iconlist",
"$$2 :",
"icons : ICONS LB $$2 newline_or_nada iconlist RB",
"atspot :",
"atspot : ATSTART",
"atspot : ATEND",
"sysmenuline : STRING STRING atspot NEWLINE newline_or_nada",
"sysmenulist : sysmenuline",
"sysmenulist : sysmenuline sysmenulist",
"$$3 :",
"sysmenu : SYSMENU LB NEWLINE $$3 newline_or_nada sysmenulist RB",
"silentexit : SILENTEXIT NEWLINE",
"debug : DEBUG STRING NEWLINE",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
int yyparse(void);
#line 180 "winprefsyacc.y"
/*
 * Errors in parsing abort and print log messages
 */
static int
yyerror (char *s) 
{
  extern int yylineno; /* Handled by flex internally */

  ErrorF("LoadPreferences: %s line %d\n", s, yylineno);
  return 1;
}

/* Miscellaneous functions to store TOKENs into the structure */
static void
SetIconDirectory (char *path)
{
  strncpy (pref.iconDirectory, path, PATH_MAX);
  pref.iconDirectory[PATH_MAX] = 0;
}

static void
SetDefaultIcon (char *fname)
{
  strncpy (pref.defaultIconName, fname, NAME_MAX);
  pref.defaultIconName[NAME_MAX] = 0;
}

static void
SetTrayIcon (char *fname)
{
  strncpy (pref.trayIconName, fname, NAME_MAX);
  pref.trayIconName[NAME_MAX] = 0;
}

static void
SetRootMenu (char *menu)
{
  strncpy (pref.rootMenuName, menu, MENU_MAX);
  pref.rootMenuName[MENU_MAX] = 0;
}

static void
SetDefaultSysMenu (char *menu, int pos)
{
  strncpy (pref.defaultSysMenuName, menu, MENU_MAX);
  pref.defaultSysMenuName[MENU_MAX] = 0;
  pref.defaultSysMenuPos = pos;
}

static void
OpenMenu (char *menuname)
{
  if (menu.menuItem) free(menu.menuItem);
  menu.menuItem = NULL;
  strncpy(menu.menuName, menuname, MENU_MAX);
  menu.menuName[MENU_MAX] = 0;
  menu.menuItems = 0;
}

static void
AddMenuLine (char *text, MENUCOMMANDTYPE cmd, char *param)
{
  if (menu.menuItem==NULL)
    menu.menuItem = (MENUITEM*)malloc(sizeof(MENUITEM));
  else
    menu.menuItem = (MENUITEM*)
      realloc(menu.menuItem, sizeof(MENUITEM)*(menu.menuItems+1));

  strncpy (menu.menuItem[menu.menuItems].text, text, MENU_MAX);
  menu.menuItem[menu.menuItems].text[MENU_MAX] = 0;

  menu.menuItem[menu.menuItems].cmd = cmd;

  strncpy(menu.menuItem[menu.menuItems].param, param, PARAM_MAX);
  menu.menuItem[menu.menuItems].param[PARAM_MAX] = 0;

  menu.menuItem[menu.menuItems].commandID = 0;

  menu.menuItems++;
}

static void
CloseMenu (void)
{
  if (menu.menuItem==NULL || menu.menuItems==0)
    {
      ErrorF("LoadPreferences: Empty menu detected\n");
      return;
    }
  
  if (pref.menuItems)
    pref.menu = (MENUPARSED*)
      realloc (pref.menu, (pref.menuItems+1)*sizeof(MENUPARSED));
  else
    pref.menu = (MENUPARSED*)malloc (sizeof(MENUPARSED));
  
  memcpy (pref.menu+pref.menuItems, &menu, sizeof(MENUPARSED));
  pref.menuItems++;

  memset (&menu, 0, sizeof(MENUPARSED));
}

static void 
OpenIcons (void)
{
  if (pref.icon != NULL) {
    ErrorF("LoadPreferences: Redefining icon mappings\n");
    free(pref.icon);
    pref.icon = NULL;
  }
  pref.iconItems = 0;
}

static void
AddIconLine (char *matchstr, char *iconfile)
{
  if (pref.icon==NULL)
    pref.icon = (ICONITEM*)malloc(sizeof(ICONITEM));
  else
    pref.icon = (ICONITEM*)
      realloc(pref.icon, sizeof(ICONITEM)*(pref.iconItems+1));

  strncpy(pref.icon[pref.iconItems].match, matchstr, MENU_MAX);
  pref.icon[pref.iconItems].match[MENU_MAX] = 0;

  strncpy(pref.icon[pref.iconItems].iconFile, iconfile, PATH_MAX+NAME_MAX+1);
  pref.icon[pref.iconItems].iconFile[PATH_MAX+NAME_MAX+1] = 0;

  pref.icon[pref.iconItems].hicon = 0;

  pref.iconItems++;
}

static void 
CloseIcons (void)
{
}

static void
OpenSysMenu (void)
{
  if (pref.sysMenu != NULL) {
    ErrorF("LoadPreferences: Redefining system menu\n");
    free(pref.sysMenu);
    pref.sysMenu = NULL;
  }
  pref.sysMenuItems = 0;
}

static void
AddSysMenuLine (char *matchstr, char *menuname, int pos)
{
  if (pref.sysMenu==NULL)
    pref.sysMenu = (SYSMENUITEM*)malloc(sizeof(SYSMENUITEM));
  else
    pref.sysMenu = (SYSMENUITEM*)
      realloc(pref.sysMenu, sizeof(SYSMENUITEM)*(pref.sysMenuItems+1));

  strncpy (pref.sysMenu[pref.sysMenuItems].match, matchstr, MENU_MAX);
  pref.sysMenu[pref.sysMenuItems].match[MENU_MAX] = 0;

  strncpy (pref.sysMenu[pref.sysMenuItems].menuName, menuname, MENU_MAX);
  pref.sysMenu[pref.sysMenuItems].menuName[MENU_MAX] = 0;

  pref.sysMenu[pref.sysMenuItems].menuPos = pos;

  pref.sysMenuItems++;
}

static void
CloseSysMenu (void)
{
}

#line 472 "winprefsyacc.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void);
static int yygrowstack(void)
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    if ((newss = (short *)realloc(yyss, newsize * sizeof *newss)) == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    if ((newvs = (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs)) == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != NULL)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
    goto yynewerror;
yynewerror:
    yyerror("syntax error");
    goto yyerrlab;
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 17:
#line 118 "winprefsyacc.y"
{ SetTrayIcon(yyvsp[-1].sVal); free(yyvsp[-1].sVal); }
break;
case 18:
#line 121 "winprefsyacc.y"
{ SetRootMenu(yyvsp[-1].sVal); free(yyvsp[-1].sVal); }
break;
case 19:
#line 124 "winprefsyacc.y"
{ SetDefaultSysMenu(yyvsp[-2].sVal, yyvsp[-1].iVal); free(yyvsp[-2].sVal); }
break;
case 20:
#line 127 "winprefsyacc.y"
{ SetDefaultIcon(yyvsp[-1].sVal); free(yyvsp[-1].sVal); }
break;
case 21:
#line 130 "winprefsyacc.y"
{ SetIconDirectory(yyvsp[-1].sVal); free(yyvsp[-1].sVal); }
break;
case 22:
#line 133 "winprefsyacc.y"
{ AddMenuLine("-", CMD_SEPARATOR, ""); }
break;
case 23:
#line 134 "winprefsyacc.y"
{ AddMenuLine(yyvsp[-3].sVal, CMD_ALWAYSONTOP, ""); free(yyvsp[-3].sVal); }
break;
case 24:
#line 135 "winprefsyacc.y"
{ AddMenuLine(yyvsp[-4].sVal, CMD_EXEC, yyvsp[-2].sVal); free(yyvsp[-4].sVal); free(yyvsp[-2].sVal); }
break;
case 25:
#line 136 "winprefsyacc.y"
{ AddMenuLine(yyvsp[-4].sVal, CMD_MENU, yyvsp[-2].sVal); free(yyvsp[-4].sVal); free(yyvsp[-2].sVal); }
break;
case 26:
#line 137 "winprefsyacc.y"
{ AddMenuLine(yyvsp[-3].sVal, CMD_RELOAD, ""); free(yyvsp[-3].sVal); }
break;
case 29:
#line 144 "winprefsyacc.y"
{ OpenMenu(yyvsp[-1].sVal); free(yyvsp[-1].sVal); }
break;
case 30:
#line 144 "winprefsyacc.y"
{CloseMenu();}
break;
case 31:
#line 147 "winprefsyacc.y"
{ AddIconLine(yyvsp[-3].sVal, yyvsp[-2].sVal); free(yyvsp[-3].sVal); free(yyvsp[-2].sVal); }
break;
case 34:
#line 154 "winprefsyacc.y"
{OpenIcons();}
break;
case 35:
#line 154 "winprefsyacc.y"
{CloseIcons();}
break;
case 36:
#line 157 "winprefsyacc.y"
{ yyval.iVal=AT_END; }
break;
case 37:
#line 158 "winprefsyacc.y"
{ yyval.iVal=AT_START; }
break;
case 38:
#line 159 "winprefsyacc.y"
{ yyval.iVal=AT_END; }
break;
case 39:
#line 162 "winprefsyacc.y"
{ AddSysMenuLine(yyvsp[-4].sVal, yyvsp[-3].sVal, yyvsp[-2].iVal); free(yyvsp[-4].sVal); free(yyvsp[-3].sVal); }
break;
case 42:
#line 169 "winprefsyacc.y"
{OpenSysMenu();}
break;
case 43:
#line 169 "winprefsyacc.y"
{CloseSysMenu();}
break;
case 44:
#line 172 "winprefsyacc.y"
{ pref.fSilentExit = TRUE; }
break;
case 45:
#line 175 "winprefsyacc.y"
{ ErrorF("LoadPreferences: %s\n", yyvsp[-1].sVal); free(yyvsp[-1].sVal); }
break;
#line 729 "winprefsyacc.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
