/*	$NetBSD: boot.h,v 1.2 2004/04/10 12:30:26 tsutsui Exp $	*/

/*-
 * Copyright (c) 2005 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BOOT_H_
#define _BOOT_H_

#include <machine/bootinfo.h>

#if defined(_DEBUG)
#define DPRINTF(x)	printf x;

void pmap_print_tlb(char which);
#else
#define DPRINTF(x)

#define pmap_print_tlb(c)	((void)0)
#endif

/* bootinfo.c */
extern u_long	bi_init(u_long addr);
extern void	bi_add(void *new, int type, size_t size);

/* sparc64.c */
extern ssize_t	sparc64_read(int f, void *addr, size_t size);
extern void*	sparc64_memcpy(void *dst, const void *src, size_t size);
extern void*	sparc64_memset(void *dst, int c, size_t size);
extern void	sparc64_bi_add(void);

/* srt0.s */
extern u_int	get_cpuid(void);

/* loadfile_machdep.c */
#define LOADFILE_USE_MMU		0x1
#define LOADFILE_USE_OPENFIRMWARE	0x2
extern void	loadfile_machdep_init(int type);

#endif /* _BOOT_H_ */
