/******************************************************************************
 * colour.c - Chapter 3 sample code                                           *
 *                                                                            *
 * This module contains arrays for the first 16 colours for pixel depths      *
 * of 8, 15, 16, 24RGB, and 32RGB                                             *
 * Also included are various primitives dealing with colour organization.     *
 * Please reference defines.h for colour codes.                               *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#include <stdio.h>
#include "defines.h"
#include "main.h"

// Arrays containing colour codes for all pixel depths.

// Colour codes for 4 & 8 bpp modes - palette entry based.

static DWORD colour_table_8[16] =
{
    0x00000000,                         // Black
    0x00000001,                         // Dark Blue
    0x00000002,                         // Dark Green
    0x00000003,                         // Dark Cyan
    0x00000004,                         // Dark Red
    0x00000005,                         // Dark Magenta
    0x00000006,                         // Brown
    0x00000007,                         // Light Gray
    0x00000008,                         // Dark Gray
    0x00000009,                         // Light Blue
    0x0000000A,                         // Light Green
    0x0000000B,                         // Light Cyan
    0x0000000C,                         // Light Red
    0x0000000D,                         // Light Magenta
    0x0000000E,                         // Yellow
    0x0000000F,                         // White
};

// Colour codes for 15 bpp (16 bpp 555 colour weight) modes - direct mapped.

static DWORD colour_table_15[16] =
{
    0x00000000,                         // Black
    0x00000014,                         // Dark Blue
    0x00000280,                         // Dark Green
    0x00000294,                         // Dark Cyan
    0x00005000,                         // Dark Red
    0x00005014,                         // Dark Magenta
    0x00005280,                         // Brown
    0x00005294,                         // Light Gray
    0x0000294A,                         // Dark Gray
    0x0000001F,                         // Light Blue
    0x000003E0,                         // Light Green
    0x000003FF,                         // Light Cyan
    0x00007C00,                         // Light Red
    0x00007C1F,                         // Light Magenta
    0x00007FE0,                         // Yellow
    0x00007FFF                          // White
};

// Colour codes for 16 bpp (16 bpp 565 colour weight) modes - direct mapped.

static DWORD colour_table_16[16] =
{
    0x00000000,                         // Black
    0x00000014,                         // Dark Blue
    0x000004C0,                         // Dark Green
    0x000004D4,                         // Dark Cyan
    0x0000A000,                         // Dark Red
    0x0000A014,                         // Dark Magenta
    0x0000A4C0,                         // Brown
    0x0000A4D4,                         // Light Gray
    0x0000528A,                         // Dark Gray
    0x0000001F,                         // Light Blue
    0x000007E0,                         // Light Green
    0x000007FF,                         // Light Cyan
    0x0000F800,                         // Light Red
    0x0000F81F,                         // Light Magenta
    0x0000FFE0,                         // Yellow
    0x0000FFFF                          // White
};

// Colour codes for 24 bpp RGB colour weight modes - direct mapped.

static DWORD colour_table_ARGB[16] =
{
    0x00000000,                         // Black
    0x0000009E,                         // Dark Blue
    0x00009E00,                         // Dark Green
    0x00009E9E,                         // Dark Cyan
    0x009E0000,                         // Dark Red
    0x009E009E,                         // Dark Magenta
    0x009E9E00,                         // Brown
    0x009E9E9E,                         // Light Gray
    0x00555555,                         // Dark Gray
    0x000000FF,                         // Light Blue
    0x0000FF00,                         // Light Green
    0x0000FFFF,                         // Light Cyan
    0x00FF0000,                         // Light Red
    0x00FF00FF,                         // Light Magenta
    0x00FFFF00,                         // Yellow
    0x00FFFFFF                          // White
};


/******************************************************************************
 * R128_GetColourCode                                                         *
 *  Function: returns the colour code for the given generic colour            *
 *    Inputs: colour_index - number 0 to 15 representing first 16 VGA colours *
 *   Outputs: colour_code - 32bit hex value indicating the colour code.       *
 ******************************************************************************/

DWORD R128_GetColourCode (WORD colour_index)
{
    colour_index %= 16;                 // Ensure index is modulo 16.

    switch (R128_AdapterInfo.bpp)
    {
        case 8:
            return (colour_table_8[colour_index]);
        case 15:
            return (colour_table_15[colour_index]);
        case 16:
            return (colour_table_16[colour_index]);
        case 24:
        case 32:
            return (colour_table_ARGB[colour_index]);
        default:
            return ((DWORD) BLACK);
    } // switch

    return (0);
} // R128_GetColourCode
