/******************************************************************************
 * Rage 128 Chapter 3 sample code                                             *
 *                                                                            *
 * nobios.c - This program sets a display mode without using the video        *
 * BIOS.  The screen is cleared.                                              *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc. All rights reserved.              *
 ******************************************************************************/
#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include "..\util\regdef.h"
#include "..\util\main.h"
#include "..\util\defines.h"

FILE *op;

void main (int argc, char *argv[])
{
    WORD result, x, y;
    DWORD temp;
    char *framebuffer;
    CRTCInfoBlock *mtable;

    op = fopen ("output.txt", "w");

    get_old_mode ();

    if (!R128_Detect ())
    {
        // shut down, and restore the old text mode.
        R128_ShutDown ();
        printf ("\nCannot detect a RAGE128 based graphics adapter.");
        printf ("\nProgram terminated.");
        exit (1);
    }
    process_command_line (argc, argv);
    R128_AdapterInfo.xres = R128_AdapterInfo.xres;
    R128_AdapterInfo.yres = R128_AdapterInfo.yres;
    R128_AdapterInfo.bpp = R128_AdapterInfo.bpp;
    if (R128_AdapterInfo.bpp == 24)
    {
        R128_AdapterInfo.pitch = R128_AdapterInfo.xres/8;
    }
    else
    {
        R128_AdapterInfo.pitch = R128_AdapterInfo.xres;
    }

    // detection tests!
    if (!R128_FindRom ())
    {
        // shut down, and restore the old text mode.
        R128_ShutDown ();
        printf ("\nRage 128 BIOS ROM not found.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    if (!R128_RegTest ())
    {
        // shut down, and restore the old text mode.
        R128_ShutDown ();
        printf ("\nRage 128 scratch register test FAILED.");
        printf ("\nProgram terminated.");
        exit (1);
    }
    PrintPanelRegs();
    GetPanelValues();
    printf ("\n");
    printf ("\n\nAttempting to set the following display mode on the DFP panel");
    printf ("\n\t*** %d x %d, %d bits per pixel. ***\n", R128_AdapterInfo.xres, 
		         R128_AdapterInfo.yres, R128_AdapterInfo.bpp);

    printf ("\n****************************************************************");
    printf ("\n* -This program will  manually set the screen to BLUE.         *");
    printf ("\n* -Pressing a key after that will exit the program.            *");
    printf ("\n****************************************************************");
    printf ("\n\n\t\tPress any key to continue.");
    printf ("\n");
    getch();
    if(!SetPanelMode(R128_AdapterInfo.xres, R128_AdapterInfo.yres, R128_AdapterInfo.bpp))
    {
      PrintPanelRegs();
      R128_ShutDown();
      printf("\nUnable to set panel mode: %d x %d, %d bpp.",R128_AdapterInfo.xres,
               R128_AdapterInfo.yres, R128_AdapterInfo.bpp);
      exit(1);
    }
    PrintPanelRegs();
    // fill the screen with blue pixels
    framebuffer = (char *)R128_AdapterInfo.virtual_MEM_BASE;

    for (x=0; x<R128_AdapterInfo.xres; x++)
    {
        for (y=0; y<R128_AdapterInfo.yres; y++)
        {
            switch (R128_AdapterInfo.bpp)
            {
                case 8:     *framebuffer = 0x09;
                            framebuffer+=1;
                            break;

                case 15:
                case 16:    *framebuffer = 0x1F;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            break;

                case 24:    *framebuffer = 0xFF;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            break;

                case 32:    *framebuffer = 0xFF;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            break;
            } // switch
        } // for (y...
    } // for (x...
/*
    for (x = 0x1; x < 0x14; x++)
    {
        //R128_WaitForFifo (1);
        temp = PLL_regr (x);
        fprintf (op, "\nPLL %2.2X: %8.8X", x, temp);
    }
  */
    fclose (op);

    // eat up the keyboard hit
    getch();

    // shut down, and restore the old text mode.
    R128_ShutDown ();

    R128_PrintInfoStruct ();
    printf ("\nDisplay mode successfully set, without using the BIOS.");
    printf ("\nX resolution: %d, Y resolution: %d, bits per pixel: %d\n",
            R128_AdapterInfo.xres, R128_AdapterInfo.yres,
            R128_AdapterInfo.bpp);

    exit (0);
}

