/******************************************************************************
 * Rage 128 Chapter 4 sample code                                               *
 *                                                                            *
 * blt.c - This program uses the engine to perform bit block transfers        *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc. All rights reserved.              *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <i86.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"

/******************************************************************************
 * Main Program to demonstrate bit block transfers (blts)                     *
 *  Function: An image is repeatedly blt'd over the screen.                   *
 *    Inputs: Arguments for mode spatial and colour resolution                *
 *   Outputs: NONE                                                            *
 ******************************************************************************/
void main (int argc, char *argv[])
{
    WORD srcx, srcy, dstx, dsty, bpp;
    DWORD temp;
    _img_info IMG_DATA;

    R128_StartUp (argc, argv);

    if (R128_AdapterInfo.xres <= 320)
    {
        R128_ShutDown ();
        printf ("\nThis program requires a resolution of at least 400x300.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    // clear the screen to yellow to start.
    R128_ClearScreen (YELLOW);

    // Set up the source data co-ordinates.
    srcx = 0;
    srcy = R128_AdapterInfo.yres;
    bpp = R128_GetBPPValue (R128_AdapterInfo.bpp);

    // Load the source image file into offscreen memory.
    IMG_DATA = Load_Image (TRAJECTORY_RECTANGULAR, bpp, srcx, srcy);

    R128_WaitForFifo (4);

    // Tell the engine where the source data resides.
    regw (SRC_Y_X, (srcy << 16) | srcx);

    // set the mix to a ROP3_SRCCOPY, and a rectangular source
    regw (DP_MIX, ROP3_SRCCOPY | DP_SRC_RECT);

    // Set the drawing direction to left->right, top->bottom
    regw (DP_CNTL, DST_X_LEFT_TO_RIGHT | DST_Y_TOP_TO_BOTTOM);

    // make the src pixel = dst pixel, in terms of pixel depth
    temp = regr (DP_DATATYPE);
    regw (DP_DATATYPE, temp | SRC_DSTCOLOR);

    // start the blt'ing loop.
    while (!kbhit ())
    {
        // calculate random destination x and y values
        dstx = (rand()%(R128_AdapterInfo.xres - IMG_DATA.width));
        dsty = (rand()%(R128_AdapterInfo.yres - IMG_DATA.height));

        R128_WaitForFifo (2);
        regw (DST_Y_X, (dsty << 16) | dstx);

        // this is the blt initiator.
        regw (DST_HEIGHT_WIDTH, (IMG_DATA.height << 16) | IMG_DATA.width);
    }

    // this will consume the keyboard hit
    getch ();

    // Batch command to restore old mode.
    R128_ShutDown ();

    exit (0);                           // No errors.

} // main

