/****************************************************************************
 * Rage 128 Chapter 4 sample code                                           *
 *                                                                          *
 * line.c - This program uses the Rage 128 engine to draw lines.            *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <i86.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"

/****************************************************************************
 * Main Program to demonstrate accelerated line drawing                     *
 *  Function: bresenham lines are repeatedly drawn on the screen.           *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    DWORD x1, y1, x2, y2;
    WORD rndclr;

    R128_StartUp (argc, argv);

    R128_ClearScreen (BLACK);

    while (!kbhit())
    //while (getch ()!=32)
    {
        // Setup parameters.
        rndclr = rand()%NUM_COLOURS;
        x1 = rand()%R128_AdapterInfo.xres;
        y1 = rand()%R128_AdapterInfo.yres;
        x2 = rand()%R128_AdapterInfo.xres;
        y2 = rand()%R128_AdapterInfo.yres;

        // Draw line.
        // See DRAWPRIM.C in the UTIL directory for details on this function
        R128_DrawLine (x1, y1, x2, y2, rndclr);

    } // while

    // Wait for user to press a key.
    getch ();

    // Batch command to restore old mode.
    R128_ShutDown ();

    exit (0);                           // No errors.

} // main

