/****************************************************************************
 * mouse.c - chapter 6 sample code                                          *
 *                                                                          *
 * To be used with Rage 128 sample code.                                    *
 * This module contains functions to detect if a mouse driver is installed, *
 * and also to get the current position of the mouse.                       *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <i86.h>
#include "regdef.h"
#include "defines.h"
#include "main.h"

/****************************************************************************
 * MOUSE_InitMouse (void)                                                   *
 *  Function: checks for an installed mouse driver                          *
 *    Inputs: NONE.                                                         *
 *   Outputs: 1 if a mouse driver is detected                               *
 *            0 if no mouse driver is detected                              *
 ****************************************************************************/
BYTE MOUSE_InitMouse (void)
{
    union REGS r;

    // check if driver is present
    r.w.ax = 0;
    int386 (0x33, &r, &r);
    if (r.w.ax == 0)
    {
        return (0);
    }
    else
    {
        return (1);
    }

}   // MOUSE_InitMouse ()


/****************************************************************************
 * MOUSE_UpdatePosition (void)                                              *
 *  Function: retrieves the current position of the mouse, and stores the   *
 *            values in the global mp structure.                            *
 *    Inputs: NONE.                                                         *
 *   Outputs: NONE.                                                         *
 ****************************************************************************/
void MOUSE_UpdatePosition (mouse_pos *mp)
{
    union REGS r;
    float dx, dy;
    float scale_x, scale_y;

    scale_x = (float)R128_AdapterInfo.xres/640.0;
    scale_y = (float)R128_AdapterInfo.yres/200.0;

    r.w.ax = 3;
    int386 (0x33, &r, &r);

    mp->x = r.w.cx;
    mp->y = r.w.dx;
    mp->buttons = r.w.bx;

    // correct position for screen resolution
    // this BIOS function always returns x positions from 0-639
    // regardless of screen resolution
    dx = (float)mp->x * scale_x;
    mp->x = (WORD)dx;

    // same for y, as return values will be between 0-199
    dy = (double)mp->y * scale_y;
    mp->y = (WORD)dy;

    return;
} // MOUSE_UpdatePosition ()

