/******************************************************************************
 * RAGE128 Chapter 5 Sample Code                                              *
 *                                                                            *
 * type3bm.c -  This program demonstrates the Concurrent Command Execution    *
 * (CCE) programming model by drawing a series of rectangles using CCE        *
 * Programmed I/O mode and Type-3 packets.                                    *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\cce.h"


/******************************************************************************
 * main                                                                       *
 *  Function: Main loop.                                                      *
 *    Inputs: none                                                            *
 *   Outputs: none                                                            *
 ******************************************************************************/

void main (int argc, char *argv[])
{
    int test;
    DWORD Buf[20];
    DWORD x, y, width, height, colour;

    printf ("Rage 128 Sample Code, Chapter 5.\n"
            "TYPE3BM.EXE\n\n"
            "This program will demonstrate using Type-3 packets with the CCE\n"
            "microengine of the Rage 128.\n\n"
            "Mode resolution (eg 640 480) and colour depth (8, 15, 16, 24, 32)\n"
            "should be passed as command line arguments.\n"
            "Default resolution and colour depth is 640x480, 8bpp.\n\n"
            "Press any key to continue.\n\n");
    getch ();

    // First, run StartUp function to set up the application

    R128_StartUp (argc, argv);

    // Clear the screen

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

    while (!kbhit ())
    {
        x = (rand () % (R128_AdapterInfo.xres));
        y = (rand () % (R128_AdapterInfo.yres));
        width = rand () % (R128_AdapterInfo.xres - x);
        height = rand () % (R128_AdapterInfo.yres - y);
        colour = R128_GetColourCode (rand () % NUM_COLOURS);

        // Set up a rectangle packet and fill the header with packet size
        // Note that packet size is two less than total number of packets sent

        Buf[0] = CCE_PACKET3_CNTL_PAINT | (3 << 16);

        // Compose GUI_CONTROL

        Buf[1] = CCE_GC_BRUSH_SOLIDCOLOR | CCE_GC_SRC_DSTCOLOR | ROP3_PATCOPY |
                 (R128_GetBPPValue (R128_AdapterInfo.bpp) << 8);

        // Colour used to draw the rectangle due to CCE_GC_BRUSH_SOLIDCOLOR

        Buf[2] = colour;

        // Fill rectangle data into packet

        Buf[3] = x + (y << 16);
        Buf[4] = (x + width) + ((y + height) << 16);

        test = R128_CCESubmitPackets (Buf, 5);
    } // while

    getch ();

    // Shut down the microengine.

    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

    return;
} // main
