; ===========================================================================
; FLUSH.ASM - Copyright (c) 1997 ATI Technologies Inc. All rights reserved
;
; Function to flush the P6 cache to enable AGP memory and GART memory to be
; written correctly.
;
; Compiling:
;   wasm -3pr -mf flush.asm
; ===========================================================================

.MODEL FLAT,C

.DATA

.CODE
.486p

; ---------------------------------------------------------------------------
; AGP_FLUSH
;
; Flush P6 cache by issuing an XCHG instruction
;
; Inputs : EAX = AGP memory base address (logical)
;
; Outputs: none
; ---------------------------------------------------------------------------
            public  AGP_flush_

AGP_flush_  proc    near

            ; save used registers
            push    edi

            ; do flush by issuing WBINVD instruction
;           db      0fh
;           db      09h
            wbinvd

            ; restore used registers
            pop     edi

            ret

AGP_flush_  endp

            end

