/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * pline3d.c - This program demonstrates how to draw a polyline using CCE   *
 * Type-3 command packets.                                                  *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <i86.h>
#include <conio.h>
#include <math.h>
#include "..\..\util\regdef.h"
#include "..\..\util\defines.h"
#include "..\..\util\main.h"
#include "..\..\util\cce.h"
#include "..\util\cntx3d.h"
#include "..\util\prim.h"

#define NUM_LINES 10
#define PI_X_2 6.28319f

char gErrMsg [64] = {0};

extern DWORD BPPOverride; // Override default 8bpp mode in Chap 3 lib.


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
	int i, exitcode = 0;
    PRIMDATA polyline;
    float centerx, centery, radius, angle, deltaangle, sinval, cosval;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "PLINE3D.EXE\n\n"
        "This program demonstrates how to draw a polyline primitive using Rage 128\n"
        "CCE Type-3 command packets.\n\n"
        "Mode resolution (eg 640 480) and colour depth (15, 16, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 32bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // Inspect arguments for invalid color depth.

    for (i = 1; i < argc; i++)
    {
        if ((strcmp (argv[i], "8") == 0) || (strcmp (argv[i], "24") == 0))
		{
			printf ("\nThis program does not operate at 8 or 24 bpp.");
			printf ("\nProgram terminated.");
			exit (1);
		}
	}

    // Override default 8bpp mode in Chap 3 lib.

    BPPOverride = 32;

    // First, run StartUp function to set up the application.

    R128_StartUp (argc, argv);

    // Clear the screen.

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

	// Set the default 3D context.

    R128_Init3DContext ();

	// Allocate a buffer for point vertices.

    polyline.verts = (TLVERTEX2*) malloc ((NUM_LINES + 1) *
        sizeof (TLVERTEX2));
	if (polyline.verts == NULL)
	{
        sprintf (gErrMsg, "polyline malloc failed!!");
		exitcode = 1;
		goto exit_app;
	}

	// Set count of vertices.

    polyline.numverts = NUM_LINES + 1;

    // Compute polygon parameters.

	centerx = R128_AdapterInfo.xres/2.0f;
	centery = R128_AdapterInfo.yres/2.0f; 
	radius = (centery * 0.9f); 
	angle = 0.0f;
    deltaangle = PI_X_2/(float) NUM_LINES;

    for (i=0; i < polyline.numverts; i++)
    {
		sinval = (float)sin ((double)angle);
		cosval = (float)cos ((double)angle);

		polyline.verts[i].x = centerx + (sinval * radius);
		polyline.verts[i].y = centery - (cosval * radius);
		polyline.verts[i].z = 0.5f;
		polyline.verts[i].rhw = 1.0f;
		polyline.verts[i].diffuse = 0x00ffffff;
		polyline.verts[i].specular = 0x00000000;
		polyline.verts[i].s2 = polyline.verts[i*2].s1 = 
		polyline.verts[i].t2 = polyline.verts[i*2].t1 = 0.0f;

		angle += deltaangle;
    }

    // Draw the polyline.

	ATTEMPT (R128_DrawPolyLine (&polyline), "Drawpolyline failed!!")

	// Wait for key press to exit.

    getch ();

exit_app:

	// Free vertex buffer.

	if (polyline.verts)
		free (polyline.verts);

	// Close 3D context, shut down micro-engine and restore original mode.

	R128_Close3DContext ();
    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

	// print error message if any.

	if (exitcode == 1)
		printf ("%s\n", gErrMsg);

	exit (exitcode);
} // main


