/******************************************************************************
 * cntx3d.h																      *
 * Header file for Rage 128 Chapter 6 sample code                             *
 * Data type definitions and function declarations for cntx3d.c.			  *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include "..\..\util\main.h"

#ifndef _CNTX3D_H
#define _CNTX3D_H

// Defines.

//#define CMD_BUF_SIZE 64
#define CMD_BUF_SIZE 300

// 3D context structure. 

typedef struct tagCONTEXT3D {
	DWORD regSCALE_3D_CNTL;
	DWORD regDST_PITCH_OFFSET_C;
    DWORD regDP_GUI_MASTER_CNTL;
    DWORD regSC_TOP_LEFT_C;
    DWORD regSC_BOTTOM_RIGHT_C;
    DWORD regZ_OFFSET_C;                   
    DWORD regZ_PITCH_C;                      
    DWORD regZ_STEN_CNTL_C;        
    DWORD regTEX_CNTL_C;                     
    DWORD regMISC_3D_STATE_CNTL_REG;         
    DWORD regTEXTURE_CLR_CMP_CLR_C;
    DWORD regTEXTURE_CLR_CMP_MSK_C;
    DWORD regFOG_COLOR_C;
    DWORD regPRIM_TEX_CNTL_C;
    DWORD regPRIM_TEXTURE_COMBINE_CNTL_C;    
    DWORD regTEX_SIZE_PITCH_C; 
    DWORD regPRIM_TEX_0_OFFSET_C;            
    DWORD regPRIM_TEX_1_OFFSET_C;            
    DWORD regPRIM_TEX_2_OFFSET_C;            
    DWORD regPRIM_TEX_3_OFFSET_C;            
    DWORD regPRIM_TEX_4_OFFSET_C;            
    DWORD regPRIM_TEX_5_OFFSET_C;            
    DWORD regPRIM_TEX_6_OFFSET_C;            
    DWORD regPRIM_TEX_7_OFFSET_C;            
    DWORD regPRIM_TEX_8_OFFSET_C;            
    DWORD regPRIM_TEX_9_OFFSET_C;            
    DWORD regPRIM_TEX_10_OFFSET_C;           
    DWORD regSEC_TEX_CNTL_C;                 
    DWORD regSEC_TEX_COMBINE_CNTL_C;         
    DWORD regSEC_TEX_0_OFFSET_C; 
    DWORD regSEC_TEX_1_OFFSET_C; 
    DWORD regSEC_TEX_2_OFFSET_C; 
    DWORD regSEC_TEX_3_OFFSET_C; 
    DWORD regSEC_TEX_4_OFFSET_C; 
    DWORD regSEC_TEX_5_OFFSET_C; 
    DWORD regSEC_TEX_6_OFFSET_C; 
    DWORD regSEC_TEX_7_OFFSET_C; 
    DWORD regSEC_TEX_8_OFFSET_C; 
    DWORD regSEC_TEX_9_OFFSET_C; 
    DWORD regSEC_TEX_10_OFFSET_C;            
    DWORD regCONSTANT_COLOR_C; 
    DWORD regPRIM_TEXTURE_BORDER_COLOR_C; 
    DWORD regSEC_TEXTURE_BORDER_COLOR_C;
    DWORD regSTEN_REF_MASK_C; 
    DWORD regPLANE_3D_MASK_C;                
    DWORD regSETUP_CNTL;
    DWORD regPM4_VC_FPU_SETUP;
	DWORD regFOG_3D_TABLE_START;
	DWORD regFOG_3D_TABLE_END;
	DWORD regFOG_3D_TABLE_DENSITY;
	DWORD FOG_TABLE [256];
} CONTEXT3D;

// Functions.

void R128_Init3DContext (void);
void R128_Close3DContext (void);

#endif // _CNTX3D_H
