/******************************************************************************
 * zbuffer.h																  *
 * Header file for Rage 128 Chapter 6 sample code                             *
 * Data type definitions and function declarations for zbuffer.c.			  *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include "..\..\util\regdef.h"
#include "..\..\util\main.h"

#ifndef _ZBUFFER_H
#define _ZBUFFER_H

// Compare function enumeration. 

typedef enum {
	CMP_NEVER = 0,
	CMP_LESS,
	CMP_LEQUAL,
	CMP_EQUAL,
	CMP_GREATER,
    CMP_GEQUAL,
    CMP_NEQUAL,
    CMP_ALWAYS,
	CMP_FORCE_DWORD = 0xffffffff,
} ECMP;

// Z mode enumeration.

typedef enum {
	ZMODE_OFF = 0,
	ZMODE_TESTWRITE,
	ZMODE_TESTNOWRITE,
	ZMODE_FORCE_DWORD = 0xffffffff,
} EZMODE;

// Z/Stencil format enumeration.

typedef enum {
	ZSTENFORMAT_Z16 = 0,
	ZSTENFORMAT_Z24,
	ZSTENFORMAT_Z32,
	ZSTENFORMAT_Z24_STEN8,
	ZSTENFORMAT_FORCE_DWORD = 0xffffffff,
} EZSTENFORMAT;

// Z buffer state enumeration.

typedef enum {
	ZBUFFERSTATE_MODE = 0,
	ZBUFFERSTATE_CMP,
	ZBUFFERSTATE_FORCE_DWORD = 0xffffffff
} EZBUFFERSTATE;

// Stencil state enumeration.

typedef enum {
    STENCILSTATE_ENABLE = 0,
    STENCILSTATE_REF,
	STENCILSTATE_CMP,
	STENCILSTATE_MASK,
	STENCILSTATE_WRITEMASK,
	STENCILSTATE_SFAILOP,
	STENCILSTATE_ZPASSOP,
	STENCILSTATE_ZFAILOP,
	STENCILSTATE_FORCE_DWORD = 0xffffffff
} ESTENCILSTATE;

// Stencil op enumeration.

typedef enum {
	STENCILOP_CURRENT = 0,
	STENCILOP_ZERO,
	STENCILOP_REF,
	STENCILOP_INC,
	STENCILOP_DEC,
	STENCILOP_NOTCURRENT,
	STENCILOP_FORCE_DWORD = 0xffffffff,
} ESTENCILOP;

// Functions.

BOOL R128_CreateZStencilBuffer (EZSTENFORMAT ZStenFormat);
BOOL R128_ClearZBuffer (DWORD ZClearValue);
BOOL R128_SetZBufferState (EZBUFFERSTATE ezstate, DWORD data);
BOOL R128_SetStencilBufferState (ESTENCILSTATE estenstate, DWORD data);
BOOL R128_ClearStencilBuffer (DWORD StencilClearValue);
void R128_FreeZStencilBuffer (void);

#endif // _ZBUFFER_H
