/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * paintmlt.c - This program demonstrates how to use Rage 128 Type-3        *
 * command packets to draw multiple rectangles.                             *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\cce.h"


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
    DWORD Buf[20];
    DWORD x, y, width, height, colour;
    int test;
    int i, j;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "PAINTMLT.EXE\n\n"
        "This program demonstrates how to use Rage 128 Type-3 command packets\n"
        "to paint multiple rectangles.\n\n"
        "Mode resolution (eg 640 480) and colour depth (8, 15, 16, 24, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 8bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // First, run StartUp function to set up the application

    R128_StartUp (argc, argv);

    // Clear the screen

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

    // Set up a rectangle packet and fill the header with packet size
    // Note that packet size is two less than total number of packets sent

    i = 0;

    Buf[i++] = CCE_PACKET3_CNTL_PAINT_MULTI;

    // Compose GUI_CONTROL

    Buf[i++] = CCE_GC_BRUSH_SOLIDCOLOR | CCE_GC_SRC_DSTCOLOR | ROP3_PATCOPY |
               (R128_GetBPPValue (R128_AdapterInfo.bpp) << 8);

    // Colour used to draw the rectangle due to CCE_GC_BRUSH_SOLIDCOLOR

    Buf[i++] = R128_GetColourCode (rand () % NUM_COLOURS);

    width = R128_AdapterInfo.xres * 0.2f;
    height = R128_AdapterInfo.yres * 0.2f;

    // Fill rectangle data into packet

    x = R128_AdapterInfo.xres * 0.2f;
    y = R128_AdapterInfo.yres * 0.2f;

    Buf[i++] = (x << 16) + y;
    Buf[i++] = (width << 16) + height;

    x = R128_AdapterInfo.xres * 0.6f;
    y = R128_AdapterInfo.yres * 0.2f;

    Buf[i++] = (x << 16) + y;
    Buf[i++] = (width << 16) + height;
    
    x = R128_AdapterInfo.xres * 0.2f;
    y = R128_AdapterInfo.yres * 0.6f;

    Buf[i++] = (x << 16) + y;
    Buf[i++] = (width << 16) + height;

    x = R128_AdapterInfo.xres * 0.6f;
    y = R128_AdapterInfo.yres * 0.6f;

    Buf[i++] = (x << 16) + y;
    Buf[i++] = (width << 16) + height;

    Buf[0] |= ((i - 2) << 16);
    test = R128_CCESubmitPackets (Buf, i);

    getch ();

    // Shut down the microengine.

    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

    return;
} // main
