/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * polyscan.c - This program demonstrates how to draw a series of polyscan  *
 * lines using Rage 128 CCE Type-3 packets.                                 *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\cce.h"


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
    DWORD Buf[50];
    DWORD xs, xe, y, height;
    int test;
    int i, j, k, scan_count, num_segment, interval;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "POLYSCAN.EXE\n\n"
        "This program demonstrates how to draw polyscan lines using Rage 128\n"
        "Type-3 CCE packets. Five segmented horizontal lines are drawn with\n"
        "increasing thickness.\n\n"
        "Mode resolution (eg 640 480) and colour depth (8, 15, 16, 24, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 8bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // First, run StartUp function to set up the application

    R128_StartUp (argc, argv);

    // Clear the screen

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

    i = 0;
    
    // Set up a polyline packet and fill the header with packet size
    // Note that packet size is two less than total number of packets sent

    Buf[i++] = CCE_PACKET3_CNTL_POLYSCANLINES;

    // Compose GUI_CONTROL

    Buf[i++] = CCE_GC_BRUSH_SOLIDCOLOR | CCE_GC_SRC_DSTCOLOR | ROP3_PATCOPY |
               (R128_GetBPPValue (R128_AdapterInfo.bpp) << 8);

    // Colour used to draw the line due to CCE_GC_BRUSH_SOLIDCOLOR

    Buf[i++] = R128_GetColourCode (LIGHTBLUE);

    Buf[i++] = 5;     //scan_count;

    interval = R128_AdapterInfo.xres / 11;
    height = 1;
    y = R128_AdapterInfo.yres/6;
    num_segment = 5;

    for (j=0; j < 5; j++)
    {

        Buf[i++] = num_segment;
        Buf[i++] = y | ((height + j) << 16);

        xs = interval;
        xe = xs + interval;

        for (k = 0; k < num_segment; k += 1)
        {
            // Fill rectangle data into packet

            Buf[i++] = xs | (xe << 16);

            xs += (interval << 1);
            xe += (interval << 1);

        } // for

        y += (R128_AdapterInfo.yres/6);

    } // for

    Buf[0] |= ((i - 2) << 16);
    test = R128_CCESubmitPackets (Buf, i);

    getch ();

    // Shut down the microengine.

    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

    return;
} // main
