/****************************************************************************
 * Rage 128 Chapter 7 sample code                                           *
 *                                                                          *
 * ov1deflt.c - This module sets the default values for the overlay/scaler  *
 *              descriptor.                                                 *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc. All rights reserved.            *
 ****************************************************************************/
#include "overlay.h"

void R128_SetOverlayDefaults (
    DWORD SrcFormat,
    DWORD SrcWidth,
    DWORD SrcHeight,
    double H_scale_ratio,
    double V_scale_ratio,
    OVERLAY_DESCRIPTOR *OverlayDescriptor
)
{
    /* Determine how the hardware (mainly memory controller and the display) is
       configured */
    OverlayDescriptor->CAN_GUARANTEE_NO_SUBPICTURE = (SrcFormat != 10);
    /* We will want to use the sub-picture in mode 10. */
    OverlayDescriptor->CAN_GUARANTEE_ONLY_ONE_VIDEO_CAPTURE = ((SrcFormat == 9) || (SrcFormat == 10));

    /* Basic Overlay Settings */
    OverlayDescriptor->SURFACE_FORMAT = SrcFormat;
    OverlayDescriptor->DOUBLE_BUFFER_REGS = 0;
    OverlayDescriptor->SrcHeight = SrcHeight;
    OverlayDescriptor->SrcWidth = SrcWidth;
    OverlayDescriptor->SurfaceIsTiled = 0;
    OverlayDescriptor->PHYSICAL_SrcLeft = (double)0;
    OverlayDescriptor->PHYSICAL_SrcRight = (double)SrcWidth;
    OverlayDescriptor->PHYSICAL_SrcTop = (double)0;
    OverlayDescriptor->PHYSICAL_SrcBottom = (double)SrcHeight;
    OverlayDescriptor->PHYSICAL_DestLeft = 0;
    OverlayDescriptor->PHYSICAL_DestRight = OverlayDescriptor->PHYSICAL_DestLeft + (int)((double)OverlayDescriptor->SrcWidth * H_scale_ratio + .5) - 1;
    OverlayDescriptor->PHYSICAL_DestTop = 0;
    OverlayDescriptor->PHYSICAL_DestBottom = OverlayDescriptor->PHYSICAL_DestTop + (int)((double)OverlayDescriptor->SrcHeight * V_scale_ratio + .5) - 1;

    /* Extended Overlay Functions */
    OverlayDescriptor->INT_EMU = 0;
    OverlayDescriptor->LOG_V_DECIMATION_FACT = 0;

    OverlayDescriptor->P1_MAX_LN_IN_PER_LN_OUT = 2;
    OverlayDescriptor->P23_MAX_LN_IN_PER_LN_OUT = 1;
    OverlayDescriptor->SCALE_Y2R_DIS = 0;

    OverlayDescriptor->VIDEO_KEY_CLR = 0;
    OverlayDescriptor->VIDEO_KEY_MSK = 0;
    OverlayDescriptor->VIDEO_KEY_FN  = 1;

    OverlayDescriptor->GRAPHICS_KEY_CLR = 0;
    OverlayDescriptor->GRAPHICS_KEY_MSK = 0;
    OverlayDescriptor->GRAPHICS_KEY_FN  = 0;

    OverlayDescriptor->COMPARE_MIX = 0;
    OverlayDescriptor->DeinterlacePattern = 0xAAAAA;
    OverlayDescriptor->DeinterlacePatternLenMinusOne = 9;

}

