/************************************************************************************************
 * OV1UTILS.C                                                                                   *
 *                                                                                              *
 *  This file contains utility functions related to enabling, disabling, and positioning        *
 *  the overlay on the Rage 128.                                                                *
 *                                                                                              *
 * Copyright (c) 1998 ATI Technologies Inc.  All rights reserved                                *
 ************************************************************************************************/
#include <stdio.h>
#include <stdlib.h>

#include "main.h"
#include "regdef.h"
#include "defines.h"
#include "overlay.h"

OVERLAY_DESCRIPTOR OverlayDescriptor;
OVERLAY_REG_FIELDS OverlayRegFields;

void R128_SetOverlay (WORD x, WORD y, WORD width, WORD height);
void R128_DisableOverlay (void);
void R128_EnableOverlay (void);

void R128_SetOverlay (WORD x, WORD y, WORD width, WORD height)
{
    WORD endy, endx;

    endx = x + width;
    if (endx >= R128_AdapterInfo.xres) endx = R128_AdapterInfo.xres - 1;
    endy = y + height;
    if (endy >= R128_AdapterInfo.yres) endy = R128_AdapterInfo.yres - 1;

    OverlayDescriptor.PHYSICAL_DestLeft = x;
    OverlayDescriptor.PHYSICAL_DestRight = endx;
    OverlayDescriptor.PHYSICAL_DestTop = y;
    OverlayDescriptor.PHYSICAL_DestBottom = endy;

    R128_SetupOverlay (&OverlayDescriptor, &OverlayRegFields);
    R128_WriteOverlayFields (&OverlayRegFields);
    R128_EnableOverlay ();

} /* R128_SetOverlay () */

void R128_DisableOverlay (void)
{
    DWORD temp;

    R128_WaitForFifo (2);
    temp = regr (OV0_SCALE_CNTL);
    temp &= 0xBFFFFFFF;
    regw (OV0_SCALE_CNTL, temp);

} /* R128_DisableOverlay () */

void R128_EnableOverlay (void)
{
    DWORD temp;

    R128_WaitForFifo (2);
    temp = regr (OV0_SCALE_CNTL);
    temp |= 0x40000000;
    regw (OV0_SCALE_CNTL, temp);

} /* R128_EnableOverlay () */
