/****************************************************************************
 * TUNER.C                                                                  *
 *                                                                          *
 * Purpose: Basic tuner functions, for use with Rage 128 and the ATI TV     *
 *          Tuner card (Brooktree 8x9 decoder)                              *
 *                                                                          *
 * Copyright (C) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "main.h"
#include "defines.h"
#include "regdef.h"

crange table[9] =
{   // min     max       freq  inc
    {   1,      1,      73.25,  6   },
    {   2,      4,      55.25,  6   },
    {   5,      6,      77.25,  6   },
    {   7,      13,     175.25, 6   },
    {   14,     22,     121.25, 6   },
    {   23,     94,     217.25, 6   },
    {   95,     99,     91.25,  6   },
    {   100,    125,    649.25, 6   },
    {   0,      0,      0,      0   }
};

/****************************************************************************
 * R128_SetTunerChannel (WORD channel)                                      *
 *  Function: Sets the tuner to a requested channel                         *
 *    Inputs: WORD channel - the tuner channel to be set.                   *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void R128_SetTunerChannel (WORD channel)
{
    BYTE i, retval;
    BYTE data[16];
    BYTE counter;
    float frequency = 0;
    float Fcar = 45.75;
    WORD divider = 0;
    _tuner_data tuner_data;
    _I2C_PACKET Packet;

    for (i = 0; table[i].increment != 0; i++)
    {
        if ( (channel >= table[i].channel_min) && (channel <= table[i].channel_max))
        {
            frequency = table[i].freq_base + Fcar + (float)(table[i].increment *
                                            (channel - table[i].channel_min));
            divider = (WORD)frequency * 16;
            break;
        }
    }

    tuner_data.div1 = (BYTE)((divider >> 8) & 0xFF);
    tuner_data.div2 = (BYTE)(divider & 0xFF);
    tuner_data.control = 0xCE;

    if ( (frequency >= LOW_BAND) && (frequency < MID_BAND))
    {
        tuner_data.band = 0xA2;
    }
    else if ( (frequency >= MID_BAND) && (frequency < MID_HIGH_BAND))
    {
        tuner_data.band = 0x94;
    }
    else if ( (frequency >= MID_HIGH_BAND) && (frequency < HIGH_BAND))
    {
        tuner_data.band = 0x34;
    }
    else
    {
        tuner_data.band = 0x31;
    }

    // Now, set the tuner to the requested channel
    data[0] = tuner_data.div1;
    data[1] = tuner_data.div2;
    data[2] = tuner_data.control;
    data[3] = tuner_data.band;
    Packet.data = data;
    Packet.start = 1;
    Packet.stop = 1;
    Packet.number_of_bytes = 4;
    Packet.address = AddressInfo.Tuner;
    counter = 0;
    do
    {
        //retval = I2C_Set (AddressInfo.Tuner, 4, &data);
        retval = I2C_Set (&Packet);
        counter++;
    }
    while ((retval != I2C_DONE) && (counter < 5));

} // R128_SetTunerChannel ()...

