/****************************************************************************
 * Project: RAGE THEATER DDK
 *
 * File:                                                                    
 *                                                                          
 * Purpose: Sample program to demonstrate VIP access/control for the Rage   
 *          Theatre chip.
 *
 * Date last modified: [MS 02-09-00] 
 *
 * Notes:       This file is provided under non-disclosure agreements.
 *              It is and remains the property of ATI Technologies Inc.
 *              Any use of this file or the information it contains to
 *              develop products commercial or otherwise must be with the
 *              permission of ATI Technologies Inc.
 *                                                                         
 * Copyright (c) 1999-2000 ATI Technologies Inc.  All rights reserved.        
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include "..\util\main.h"
#include "..\util\defines.h"
#include "..\util\regdef.h"
//#include "vip.h"

/****************************************************************************
 * Main Program to demonstrate VIP access for the Rage 128 -> Rage Theatre  *
 *  Function: The Rage Theater decoder is detected, and the device ID and   *
 *            revision are read back.                                       *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    DWORD temp;

    R128_Detect ();
    R128_FindRom ();
    R128_RegTest ();
    R128_GetPLLInfo ();

    R128_InitVIP ();
    printf ("\nVIP subsystem initialized.");

    RT_DEVICE_NUM = RT_GetVIPAddress ();
    printf ("\nRT_DEVICE_NUM: %d", RT_DEVICE_NUM);
    if (RT_DEVICE_NUM < 0)
    {
        printf ("\nCould not locate Rage Theatre device.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    printf ("\nRage Theatre located at VIP device number %d", RT_DEVICE_NUM);

    RT_regr (VIP_VIP_VENDOR_DEVICE_ID, &temp);
    printf ("\nRage Theatre Device ID: %8.8X", temp);
    RT_regr (VIP_VIP_REVISION_ID, &temp);
    printf ("\nRage Theatre Revision: %8.8X\n", temp);

    exit (0);

} // main ()...


