#	$NetBSD: bsd.prog.mk,v 1.100 1999/02/12 01:10:08 lukem Exp $
#	@(#)bsd.prog.mk	8.2 (Berkeley) 4/2/94

.if !target(__initialized__)
__initialized__:
.if exists(${.CURDIR}/../Makefile.inc)
.include "${.CURDIR}/../Makefile.inc"
.endif
.include <bsd.own.mk>
.include <bsd.obj.mk>
.MAIN:		all
.endif

.PHONY:		cleanprog proginstall scriptsinstall
realinstall:	proginstall scriptsinstall
clean cleandir distclean: cleanprog

CFLAGS+=	${COPTS}

# ELF platforms depend on crtbegin.o and crtend.o
.if ${OBJECT_FMT} == "ELF" && ${OS} == "NetBSD.1"
LIBCRTBEGIN?=	${DESTDIR}/usr/lib/crtbegin.o
LIBCRTEND?=	${DESTDIR}/usr/lib/crtend.o
.else
LIBCRTBEGIN?=
LIBCRTEND?=
.endif

.if ${OS} == "NetBSD.1"
LIB_STD?=	${DESTDIR}/usr/lib
LIB_EXT?=	${DESTDIR}/usr/lib
LIBCRT0?=	${LIB_STD}/crt0.o
.else
LIB_STD?=	${DESTDIR}/usr/lib
LIB_EXT?=	${DESTDIR}${USRDIR}/lib
.endif

LIBBFD?=	${LIB_EXT}/libbfd.a
LIBBZ2?=	${LIB_EXT}/libbz2.a
LIBC?=		${LIB_STD}/libc.a
LIBC_PIC?=	${LIB_STD}/libc_pic.a
LIBCOMPAT?=	${LIB_EXT}/libcompat.a
LIBCRYPT?=	${LIB_EXT}/libcrypt.a
LIBCURSES?=	${LIB_STD}/libcurses.a
LIBDBM?=	${LIB_EXT}/libdbm.a
LIBDES?=	${LIB_EXT}/libdes.a
LIBEDIT?=	${LIB_EXT}/libedit.a
LIBGCC?=	${LIB_EXT}/libgcc.a
LIBGNUMALLOC?=	${LIB_EXT}/libgnumalloc.a
LIBKDB?=	${LIB_EXT}/libkdb.a
LIBKRB?=	${LIB_EXT}/libkrb.a
LIBKVM?=	${LIB_EXT}/libkvm.a
LIBL?=		${LIB_STD}/libl.a
LIBM?=		${LIB_STD}/libm.a
LIBMP?=		${LIB_EXT}/libmp.a
LIBNTP?=	${LIB_EXT}/libntp.a
LIBOBJC?=	${LIB_EXT}/libobjc.a
LIBPC?=		${LIB_EXT}/libpc.a
LIBPCAP?=	${LIB_EXT}/libpcap.a
LIBPLOT?=	${LIB_EXT}/libplot.a
LIBPOSIX?=	${LIB_EXT}/libposix.a
LIBRESOLV?=	${LIB_EXT}/libresolv.a
LIBRPCSVC?=	${LIB_EXT}/librpcsvc.a
LIBSKEY?=	${LIB_EXT}/libskey.a
LIBTERMCAP?=	${LIB_EXT}/libtermcap.a
LIBTELNET?=	${LIB_EXT}/libtelnet.a
LIBUTIL?=	${LIB_EXT}/libutil.a
LIBWRAP?=	${LIB_EXT}/libwrap.a
LIBY?=		${LIB_STD}/liby.a
LIBZ?=		${LIB_EXT}/libz.a

.if defined(SHAREDSTRINGS)
CLEANFILES+=strings
.c.o:
	${CC} -E ${CFLAGS} ${.IMPSRC} | xstr -c -
	@${CC} ${CFLAGS} -c x.c -o ${.TARGET}
	@rm -f x.c

.cc.o:
	${CXX} -E ${CXXFLAGS} ${.IMPSRC} | xstr -c -
	@mv -f x.c x.cc
	@${CXX} ${CXXFLAGS} -c x.cc -o ${.TARGET}
	@rm -f x.cc

.C.o:
	${CXX} -E ${CXXFLAGS} ${.IMPSRC} | xstr -c -
	@mv -f x.c x.C
	@${CXX} ${CXXFLAGS} -c x.C -o ${.TARGET}
	@rm -f x.C
.endif


.if defined(PROG)
SRCS?=		${PROG}.c

DPSRCS+=	${SRCS:M*.l:.l=.c} ${SRCS:M*.y:.y=.c}
CLEANFILES+=	${DPSRCS}
.if defined(YHEADER)
CLEANFILES+=	${SRCS:M*.y:.y=.h}
.endif

.if !empty(SRCS:N*.h:N*.sh)
OBJS+=		${SRCS:N*.h:N*.sh:R:S/$/.o/g}
LOBJS+=		${LSRCS:.c=.ln} ${SRCS:M*.c:.c=.ln}
.endif

.if defined(OBJS) && !empty(OBJS)
.NOPATH: ${OBJS}
${PROG}: ${LIBCRT0} ${DPSRCS} ${OBJS} ${LIBC} ${LIBCRTBEGIN} ${LIBCRTEND} ${DPADD}
.if defined(DESTDIR) && ${OS} == "NetBSD.1"
	${CC} ${LDFLAGS} ${LDSTATIC} -o ${.TARGET} -nostdlib -L${DESTDIR}/usr/lib ${LIBCRT0} ${LIBCRTBEGIN} ${OBJS} ${LDADD} -lgcc -lc -lgcc ${LIBCRTEND}
.else
	${CC} ${LDFLAGS} ${LDSTATIC} -o ${.TARGET} ${OBJS} ${LDADD}
.endif	# defined(DESTDIR) && ${OS} == "NetBSD.1"
.endif	# defined(OBJS) && !empty(OBJS)

.if !defined(MAN)
MAN=	${PROG}.1
.endif	# !defined(MAN)
.endif	# defined(PROG)

all: ${PROG}

cleanprog:
	rm -f a.out [Ee]rrs mklog core *.core \
	    ${PROG} ${OBJS} ${LOBJS} ${CLEANFILES}

.if defined(SRCS)
afterdepend: .depend
	@(TMP=/tmp/_depend$$$$; \
	    sed -e 's/^\([^\.]*\).o[ ]*:/\1.o \1.ln:/' \
	      < .depend > $$TMP; \
	    mv $$TMP .depend)
.endif

.if defined(PROG) && !target(proginstall)
PROGNAME?= ${PROG}
proginstall:: ${DESTDIR}${BINDIR}/${PROGNAME}
.if !defined(UPDATE)
.PHONY: ${DESTDIR}${BINDIR}/${PROGNAME}
.endif
.if !defined(BUILD)
${DESTDIR}${BINDIR}/${PROGNAME}: .MADE
.endif

.PRECIOUS: ${DESTDIR}${BINDIR}/${PROGNAME}
${DESTDIR}${BINDIR}/${PROGNAME}: ${PROG}
	${INSTALL} ${RENAME} ${PRESERVE} ${COPY} ${STRIPFLAG} -o ${BINOWN} \
	    -g ${BINGRP} -m ${BINMODE} ${.ALLSRC} ${.TARGET}
.endif

.if !target(proginstall)
proginstall::
.endif

.if defined(SCRIPTS) && !target(scriptsinstall)
SCRIPTSDIR?=${BINDIR}
SCRIPTSOWN?=${BINOWN}
SCRIPTSGRP?=${BINGRP}
SCRIPTSMODE?=${BINMODE}
.for S in ${SCRIPTS}
SCRIPTSDIR_${S}?=${SCRIPTSDIR}
SCRIPTSOWN_${S}?=${SCRIPTSOWN}
SCRIPTSGRP_${S}?=${SCRIPTSGRP}
SCRIPTSMODE_${S}?=${SCRIPTSMODE}
.if defined(SCRIPTSNAME)
SCRIPTSNAME_${S} ?= ${SCRIPTSNAME}
.else
SCRIPTSNAME_${S} ?= ${S:T:R}
.endif
SCRIPTSDIR_${S} ?= ${SCRIPTSDIR}
scriptsinstall:: ${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}
.if !defined(UPDATE)
.PHONY: ${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}
.endif
.if !defined(BUILD)
${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}: .MADE
.endif

.PRECIOUS: ${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}
${DESTDIR}${SCRIPTSDIR_${S}}/${SCRIPTSNAME_${S}}: ${S}
	${INSTALL} ${RENAME} ${PRESERVE} ${COPY} -o ${SCRIPTSOWN_${S}} -g \
	    ${SCRIPTSGRP_${S}} -m ${SCRIPTSMODE_${S}} ${.ALLSRC} ${.TARGET}
.endfor
.endif

.if !target(scriptsinstall)
scriptsinstall::
.endif

lint: ${LOBJS}
.if defined(LOBJS) && !empty(LOBJS)
	${LINT} ${LINTFLAGS} ${LDFLAGS:M-L*} ${LOBJS} ${LDADD}
.endif

.include <bsd.man.mk>
.include <bsd.nls.mk>
.include <bsd.files.mk>
.include <bsd.inc.mk>
.include <bsd.links.mk>
.include <bsd.dep.mk>
.include <bsd.sys.mk>

# Make sure all of the standard targets are defined, even if they do nothing.
regress:
