/*	$NetBSD: stdlib.h,v 1.4 2001/07/04 20:52:37 christos Exp $	*/

/*-
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Christos Zoulas.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BSD_STDLIB_H_
#define _BSD_STDLIB_H_

#include <sys/cdefs.h>

#define malloc __malloc
#define calloc __calloc
#define realloc __realloc
#define free __free
#ifdef __linux__
#ifndef _BSD___LONG_DOUBLE_T_
#define _BSD___LONG_DOUBLE_T_ long double
typedef _BSD___LONG_DOUBLE_T_  __long_double_t;
#endif
#endif

__BEGIN_DECLS
#include <native/stdlib.h>
#include <limits.h>
__END_DECLS

#undef malloc
#undef realloc
#undef calloc
#undef free

#include <sys/types.h>

#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS	0
#endif
#ifndef EXIT_FAILURE
# define EXIT_FAILURE	1
#endif

__BEGIN_DECLS
void* malloc __P((size_t));
void* realloc __P((void*, size_t));
void* calloc __P((size_t, size_t));
void  free __P((void*));

int setenv __P((const char *, const char *, int));
void unsetenv __P((const char *));

extern int optind, opterr;
extern char* optarg;
char *getbsize __P((int *, long *));

quad_t strtoq __P((const char *, char **, int));
u_quad_t strtouq __P((const char *, char **, int));
long long strtoll __P((const char *, char **, int));
unsigned long long strtoull __P((const char *, char **, int));

char *mkdtemp __P((char *));

char	*cgetcap __P((char *, const char *, int));
int	 cgetclose __P((void));
int	 cgetent __P((char **, char **, const char *));
int	 cgetfirst __P((char **, char **));
int	 cgetmatch __P((const char *, const char *));
int	 cgetnext __P((char **, char **));
int	 cgetnum __P((char *, const char *, long *));
int	 cgetset __P((const char *));
int	 cgetstr __P((char *, const char *, char **));
int	 cgetustr __P((char *, const char *, char **));


__END_DECLS

#endif
