/*	$NetBSD: unistd.h,v 1.7 2001/07/04 20:52:37 christos Exp $	*/

/*-
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Christos Zoulas.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _BSD_UNISTD_H_
#define _BSD_UNISTD_H_

#include <sys/cdefs.h>

__BEGIN_DECLS
#ifdef __SVR4
#define _exit ____exit
#include <native/sys/mutex.h>
#include <native/sys/condvar.h>
#endif
#ifdef __linux__
#include <sys/types.h>
#define __getcwd ___getcwd
#endif
#include <native/unistd.h>
#include <native/sys/file.h>
#ifdef __SVR4
#undef _exit
#endif
#ifdef __linux__
#undef __getcwd
#endif

void _exit __P((int)) __attribute__((__noreturn__));
void *setmode __P((const char *));
mode_t getmode __P((const void *, mode_t));
char *getusershell __P((void));
int getgrouplist __P((const char *, gid_t, gid_t *, int *));

int chflags __P((const char *, u_long));
int fchflags __P((int, u_long));

int lutimes __P((const char *, const struct timeval *));
int lchmod __P((const char *, mode_t));

#ifndef __linux__
void swab __P((const void *, void *, ssize_t));
#endif

#ifndef __SVR4
int gethostname __P((char *, size_t));
#endif
int sethostname __P((const char *, size_t));

int getdomainname __P((char *, size_t));
int setdomainname __P((const char *, size_t));

void strmode __P((mode_t, char *));

int undelete __P((const char *));
int revoke __P((const char *));

int iruserok __P((u_int32_t, int, const char *, const char *));

extern __const char* __const sys_siglist[];
extern __const char* __const sys_signame[];

#if !defined(SUNOS_5_7) && !defined(SUNOS_5_8) /*INET6*/
#include <sys/socket.h>
int	rresvport_af __P((int *, sa_family_t));
int	ruserok_af __P((const char *, int, const char *, const char *, sa_family_t));
int	iruserok_af __P((const void *, int, const char *, const char *, sa_family_t));
#endif 

#ifdef __linux__
ssize_t  pread __P((int, void *, size_t, off_t)); 
ssize_t  pwrite __P((int, const void *, size_t, off_t));
#endif

__END_DECLS

#endif /* _BSD_UNISTD_H_ */
