/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;
import java.util.TreeMap;

public class OneTopLevelClassCheck
extends Check {
    private boolean mPublicTypeFound;
    private TreeMap<Integer, String> mLineNumberTypeMap = new TreeMap();

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        for (DetailAST currentNode = aRootAST; currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getType() != 14 && currentNode.getType() != 158 && currentNode.getType() != 15) continue;
            if (this.isPublic(currentNode)) {
                this.mPublicTypeFound = true;
                continue;
            }
            String typeName = currentNode.findFirstToken(59).getText();
            this.mLineNumberTypeMap.put(currentNode.getLineNo(), typeName);
        }
    }

    @Override
    public void finishTree(DetailAST aRootAST) {
        if (!this.mPublicTypeFound && !this.mLineNumberTypeMap.isEmpty()) {
            this.mLineNumberTypeMap.remove(this.mLineNumberTypeMap.firstKey());
        }
        for (Map.Entry<Integer, String> entry : this.mLineNumberTypeMap.entrySet()) {
            this.log((int)entry.getKey(), "one.top.level.class", entry.getValue());
        }
        this.mLineNumberTypeMap.clear();
        this.mPublicTypeFound = false;
    }

    private boolean isPublic(DetailAST aTypeDef) {
        DetailAST modifiers = aTypeDef.findFirstToken(5);
        return modifiers.findFirstToken(63) != null;
    }
}

