/*	$NetBSD$$	*/

/* These register layouts are very similar to (same as) the nhpib ones */

#define FHPIB_CID		1		/* (R) controller id */
#define FHPIB_RESET		1		/* (W) reset */
#define FHPIB_CSR		3		/* (RW) control/status */
#define		CSR_WDMA	0x04			/* word DMA */
#define		CSR_WRITE	0x08			/* DMA write */
#define		CSR_IR		0x40			/* read done */
#define		CSR_IE		0x80			/* interrupt enable */
#define		CSR_DMA(x)	(1 << (x))		/* enable DMA */
#define FHPIB_CTRL2		5
#define FHPIB_LATCH		7		/* (W) DMA ? */

#define FHPIB_CHIPOFFSET	16	/* offset of chip registers */

#define FHPIB_INTR		1
#define FHPIB_IMASK		3
#define		IMASK_PABORT	0x40
#define		IMASK_PPRESP	0x20
#define		IMASK_ROOM	0x08
#define		IMASK_BYTE	0x04
#define		IMASK_IDLE	0x02
#define FHPIB_DATA		5		/* (RW) */
#define FHPIB_STAT		7		/* (RW) status/control */
#define		STAT_READ0	0xC0
#define		STAT_READ1	0x80
#define		STAT_IENAB	0x80
#define		STAT_EOI	0x80
#define		STAT_ATN	0x40
#define		STAT_WRITE	0x00
#define FHPIB_CMD		9		/* (RW) */
#define		CMD_8BIT	0x80
#define		CMD_REN		0x20
#define		CMD_IFC		0x10
#define		CMD_FIFOSEL	0x02
#define		CMD_INITFIFO	0x01
#define FHPIB_AR		11		/* (W) */
#define		AR_ARONC	0x80
#define FHPIB_PMASK		13
#define FHPIB_PSENSE		15
