/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.event;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.event.EventClient;
import javax.management.event.EventClientDelegate;
import javax.management.event.EventConsumer;
import javax.management.event.NotificationManager;

public interface EventConnection
extends MBeanServerConnection,
EventConsumer {
    public EventClient getEventClient();

    public static class Factory {
        public static EventConnection make(final MBeanServerConnection mBeanServerConnection, final EventClient eventClient) throws IOException {
            if (!mBeanServerConnection.isRegistered(EventClientDelegate.OBJECT_NAME)) {
                throw new IOException("The server does not support the event service.");
            }
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    Class<?> clazz = method.getDeclaringClass();
                    try {
                        if (clazz.isInstance(eventClient)) {
                            return method.invoke(eventClient, objectArray);
                        }
                        return method.invoke(mBeanServerConnection, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                }
            };
            return (EventConnection)Proxy.newProxyInstance(NotificationManager.class.getClassLoader(), new Class[]{NotificationManager.class, EventConnection.class}, invocationHandler);
        }
    }
}

