/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.event;

import com.sun.jmx.event.DaemonThreadFactory;
import com.sun.jmx.event.EventParams;
import com.sun.jmx.remote.util.ClassLogger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LeaseManager {
    private final Runnable callback;
    private ScheduledFuture<?> scheduled;
    private static final ThreadFactory threadFactory = new DaemonThreadFactory("JMX LeaseManager %d");
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, threadFactory);
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "LeaseManager");

    public LeaseManager(Runnable runnable) {
        this(runnable, EventParams.getLeaseTimeout());
    }

    public LeaseManager(Runnable runnable, long l) {
        if (logger.traceOn()) {
            logger.trace("LeaseManager", "new manager with lease: " + l);
        }
        if (runnable == null) {
            throw new NullPointerException("Null callback.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive: " + l);
        }
        this.callback = runnable;
        this.schedule(l);
    }

    public synchronized long lease(long l) {
        if (logger.traceOn()) {
            logger.trace("lease", "new lease to: " + l);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative lease: " + l);
        }
        if (this.scheduled == null) {
            return 0L;
        }
        this.scheduled.cancel(false);
        if (logger.traceOn()) {
            logger.trace("lease", "start lease: " + l);
        }
        this.schedule(l);
        return l;
    }

    private synchronized void schedule(long l) {
        Expire expire = new Expire();
        this.scheduled = this.executor.schedule(expire, l, TimeUnit.MILLISECONDS);
        expire.task = this.scheduled;
    }

    public synchronized void stop() {
        logger.trace("stop", "canceling lease");
        this.scheduled.cancel(false);
        this.scheduled = null;
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            logger.trace("stop", "exception from executor.shutdown", securityException);
        }
    }

    private class Expire
    implements Runnable {
        ScheduledFuture<?> task;

        private Expire() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LeaseManager leaseManager = LeaseManager.this;
            synchronized (leaseManager) {
                if (this.task.isCancelled()) {
                    return;
                }
                LeaseManager.this.scheduled = null;
            }
            LeaseManager.this.callback.run();
            LeaseManager.this.executor.shutdown();
        }
    }
}

