/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.streaming;

import com.sun.xml.internal.ws.streaming.Attributes;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamReaderUtil {
    private XMLStreamReaderUtil() {
    }

    public static void close(XMLStreamReader xMLStreamReader) {
        try {
            xMLStreamReader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw XMLStreamReaderUtil.wrapException(xMLStreamException);
        }
    }

    public static int next(XMLStreamReader xMLStreamReader) {
        try {
            int n = xMLStreamReader.next();
            while (n != 8) {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: {
                        return n;
                    }
                }
                n = xMLStreamReader.next();
            }
            return n;
        }
        catch (XMLStreamException xMLStreamException) {
            throw XMLStreamReaderUtil.wrapException(xMLStreamException);
        }
    }

    public static int nextElementContent(XMLStreamReader xMLStreamReader) {
        int n = XMLStreamReaderUtil.nextContent(xMLStreamReader);
        if (n == 4) {
            throw new XMLStreamReaderException("xmlreader.unexpectedCharacterContent", xMLStreamReader.getText());
        }
        return n;
    }

    public static int nextContent(XMLStreamReader xMLStreamReader) {
        while (true) {
            int n = XMLStreamReaderUtil.next(xMLStreamReader);
            switch (n) {
                case 1: 
                case 2: 
                case 8: {
                    return n;
                }
                case 4: {
                    if (xMLStreamReader.isWhiteSpace()) break;
                    return 4;
                }
            }
        }
    }

    public static void skipElement(XMLStreamReader xMLStreamReader) {
        assert (xMLStreamReader.getEventType() == 1);
        XMLStreamReaderUtil.skipTags(xMLStreamReader, true);
        assert (xMLStreamReader.getEventType() == 2);
    }

    public static void skipSiblings(XMLStreamReader xMLStreamReader, QName qName) {
        XMLStreamReaderUtil.skipTags(xMLStreamReader, xMLStreamReader.getName().equals(qName));
        assert (xMLStreamReader.getEventType() == 2);
    }

    private static void skipTags(XMLStreamReader xMLStreamReader, boolean bl) {
        try {
            int n;
            int n2 = 0;
            while ((n = xMLStreamReader.next()) != 8) {
                if (n == 1) {
                    ++n2;
                    continue;
                }
                if (n != 2) continue;
                if (n2 == 0 && bl) {
                    return;
                }
                --n2;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw XMLStreamReaderUtil.wrapException(xMLStreamException);
        }
    }

    public static String getElementText(XMLStreamReader xMLStreamReader) {
        try {
            return xMLStreamReader.getElementText();
        }
        catch (XMLStreamException xMLStreamException) {
            throw XMLStreamReaderUtil.wrapException(xMLStreamException);
        }
    }

    public static QName getElementQName(XMLStreamReader xMLStreamReader) {
        try {
            String string = xMLStreamReader.getElementText();
            String string2 = string.substring(0, string.indexOf(58));
            String string3 = xMLStreamReader.getNamespaceURI(string2);
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string.substring(string.indexOf(58) + 1, string.length());
            return new QName(string3, string4);
        }
        catch (XMLStreamException xMLStreamException) {
            throw XMLStreamReaderUtil.wrapException(xMLStreamException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Attributes getAttributes(XMLStreamReader xMLStreamReader) {
        if (xMLStreamReader.getEventType() != 1) {
            if (xMLStreamReader.getEventType() != 10) return null;
        }
        AttributesImpl attributesImpl = new AttributesImpl(xMLStreamReader);
        return attributesImpl;
    }

    public static void verifyReaderState(XMLStreamReader xMLStreamReader, int n) {
        int n2 = xMLStreamReader.getEventType();
        if (n2 != n) {
            throw new XMLStreamReaderException("xmlreader.unexpectedState", XMLStreamReaderUtil.getStateName(n), XMLStreamReaderUtil.getStateName(n2));
        }
    }

    public static void verifyTag(XMLStreamReader xMLStreamReader, QName qName) {
        if (!qName.equals(xMLStreamReader.getName())) {
            throw new XMLStreamReaderException("xmlreader.unexpectedState.tag", qName, xMLStreamReader.getName());
        }
    }

    public static String getStateName(XMLStreamReader xMLStreamReader) {
        return XMLStreamReaderUtil.getStateName(xMLStreamReader.getEventType());
    }

    public static String getStateName(int n) {
        switch (n) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return "UNKNOWN";
    }

    private static XMLStreamReaderException wrapException(XMLStreamException xMLStreamException) {
        return new XMLStreamReaderException("xmlreader.ioException", new Object[]{xMLStreamException});
    }

    public static class AttributesImpl
    implements Attributes {
        static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
        AttributeInfo[] atInfos;

        public AttributesImpl(XMLStreamReader xMLStreamReader) {
            if (xMLStreamReader == null) {
                this.atInfos = new AttributeInfo[0];
            } else {
                int n;
                int n2 = 0;
                String string = null;
                int n3 = xMLStreamReader.getNamespaceCount();
                int n4 = xMLStreamReader.getAttributeCount();
                this.atInfos = new AttributeInfo[n3 + n4];
                for (n = 0; n < n3; ++n) {
                    string = xMLStreamReader.getNamespacePrefix(n);
                    if (string == null) {
                        string = "";
                    }
                    this.atInfos[n2++] = new AttributeInfo(new QName(XMLNS_NAMESPACE_URI, string, "xmlns"), xMLStreamReader.getNamespaceURI(n));
                }
                for (n = 0; n < n4; ++n) {
                    this.atInfos[n2++] = new AttributeInfo(xMLStreamReader.getAttributeName(n), xMLStreamReader.getAttributeValue(n));
                }
            }
        }

        public int getLength() {
            return this.atInfos.length;
        }

        public String getLocalName(int n) {
            if (n >= 0 && n < this.atInfos.length) {
                return this.atInfos[n].getLocalName();
            }
            return null;
        }

        public QName getName(int n) {
            if (n >= 0 && n < this.atInfos.length) {
                return this.atInfos[n].getName();
            }
            return null;
        }

        public String getPrefix(int n) {
            if (n >= 0 && n < this.atInfos.length) {
                return this.atInfos[n].getName().getPrefix();
            }
            return null;
        }

        public String getURI(int n) {
            if (n >= 0 && n < this.atInfos.length) {
                return this.atInfos[n].getName().getNamespaceURI();
            }
            return null;
        }

        public String getValue(int n) {
            if (n >= 0 && n < this.atInfos.length) {
                return this.atInfos[n].getValue();
            }
            return null;
        }

        public String getValue(QName qName) {
            int n = this.getIndex(qName);
            if (n != -1) {
                return this.atInfos[n].getValue();
            }
            return null;
        }

        public String getValue(String string) {
            int n = this.getIndex(string);
            if (n != -1) {
                return this.atInfos[n].getValue();
            }
            return null;
        }

        public String getValue(String string, String string2) {
            int n = this.getIndex(string, string2);
            if (n != -1) {
                return this.atInfos[n].getValue();
            }
            return null;
        }

        public boolean isNamespaceDeclaration(int n) {
            if (n >= 0 && n < this.atInfos.length) {
                return this.atInfos[n].isNamespaceDeclaration();
            }
            return false;
        }

        public int getIndex(QName qName) {
            for (int i = 0; i < this.atInfos.length; ++i) {
                if (!this.atInfos[i].getName().equals(qName)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String string) {
            for (int i = 0; i < this.atInfos.length; ++i) {
                if (!this.atInfos[i].getName().getLocalPart().equals(string)) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(String string, String string2) {
            for (int i = 0; i < this.atInfos.length; ++i) {
                QName qName = this.atInfos[i].getName();
                if (!qName.getNamespaceURI().equals(string) || !qName.getLocalPart().equals(string2)) continue;
                return i;
            }
            return -1;
        }

        static class AttributeInfo {
            private QName name;
            private String value;

            public AttributeInfo(QName qName, String string) {
                this.name = qName;
                this.value = string == null ? "" : string;
            }

            QName getName() {
                return this.name;
            }

            String getValue() {
                return this.value;
            }

            String getLocalName() {
                if (this.isNamespaceDeclaration()) {
                    if (this.name.getLocalPart().equals("")) {
                        return "xmlns";
                    }
                    return "xmlns:" + this.name.getLocalPart();
                }
                return this.name.getLocalPart();
            }

            boolean isNamespaceDeclaration() {
                return this.name.getNamespaceURI() == AttributesImpl.XMLNS_NAMESPACE_URI;
            }
        }
    }
}

