/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountDownLatch {
    private final Sync sync;

    public CountDownLatch(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(n);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(l));
    }

    public void countDown() {
        this.sync.releaseShared(1);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync(int n) {
            this.setState(n);
        }

        int getCount() {
            return this.getState();
        }

        protected int tryAcquireShared(int n) {
            return this.getState() == 0 ? 1 : -1;
        }

        protected boolean tryReleaseShared(int n) {
            int n2;
            int n3;
            do {
                if ((n3 = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(n3, n2 = n3 - 1));
            return n2 == 0;
        }
    }
}

