/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import com.sun.beans.ObjectHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.DefaultSynthStyleFactory;
import javax.swing.plaf.synth.ImagePainter;
import javax.swing.plaf.synth.ParsedSynthStyle;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynthParser
extends HandlerBase {
    private static final String ELEMENT_SYNTH = "synth";
    private static final String ELEMENT_STYLE = "style";
    private static final String ELEMENT_STATE = "state";
    private static final String ELEMENT_FONT = "font";
    private static final String ELEMENT_COLOR = "color";
    private static final String ELEMENT_IMAGE_PAINTER = "imagePainter";
    private static final String ELEMENT_PAINTER = "painter";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_SYNTH_GRAPHICS = "graphicsUtils";
    private static final String ELEMENT_IMAGE_ICON = "imageIcon";
    private static final String ELEMENT_BIND = "bind";
    private static final String ELEMENT_BIND_KEY = "bindKey";
    private static final String ELEMENT_INSETS = "insets";
    private static final String ELEMENT_OPAQUE = "opaque";
    private static final String ELEMENT_DEFAULTS_PROPERTY = "defaultsProperty";
    private static final String ELEMENT_INPUT_MAP = "inputMap";
    private static final String ATTRIBUTE_ACTION = "action";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_IDREF = "idref";
    private static final String ATTRIBUTE_CLONE = "clone";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_STYLE = "style";
    private static final String ATTRIBUTE_SIZE = "size";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_TOP = "top";
    private static final String ATTRIBUTE_LEFT = "left";
    private static final String ATTRIBUTE_BOTTOM = "bottom";
    private static final String ATTRIBUTE_RIGHT = "right";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_SOURCE_INSETS = "sourceInsets";
    private static final String ATTRIBUTE_DEST_INSETS = "destinationInsets";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_STRETCH = "stretch";
    private static final String ATTRIBUTE_PAINT_CENTER = "paintCenter";
    private static final String ATTRIBUTE_METHOD = "method";
    private static final String ATTRIBUTE_DIRECTION = "direction";
    private static final String ATTRIBUTE_CENTER = "center";
    private ObjectHandler _handler;
    private int _depth;
    private DefaultSynthStyleFactory _factory;
    private List<ParsedSynthStyle.StateInfo> _stateInfos;
    private ParsedSynthStyle _style;
    private ParsedSynthStyle.StateInfo _stateInfo;
    private List<String> _inputMapBindings;
    private String _inputMapID;
    private Map<String, Object> _mapping = new HashMap<String, Object>();
    private URL _urlResourceBase;
    private Class<?> _classResourceBase;
    private List<ColorType> _colorTypes;
    private Map<String, Object> _defaultsMap;
    private List<ParsedSynthStyle.PainterInfo> _stylePainters;
    private List<ParsedSynthStyle.PainterInfo> _statePainters;

    SynthParser() {
        this._stateInfos = new ArrayList<ParsedSynthStyle.StateInfo>();
        this._colorTypes = new ArrayList<ColorType>();
        this._inputMapBindings = new ArrayList<String>();
        this._stylePainters = new ArrayList<ParsedSynthStyle.PainterInfo>();
        this._statePainters = new ArrayList<ParsedSynthStyle.PainterInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, DefaultSynthStyleFactory defaultSynthStyleFactory, URL uRL, Class<?> clazz, Map<String, Object> map) throws ParseException, IllegalArgumentException {
        if (inputStream == null || defaultSynthStyleFactory == null || uRL == null && clazz == null) {
            throw new IllegalArgumentException("You must supply an InputStream, StyleFactory and Class or URL");
        }
        assert (uRL == null || clazz == null);
        this._factory = defaultSynthStyleFactory;
        this._classResourceBase = clazz;
        this._urlResourceBase = uRL;
        this._defaultsMap = map;
        try {
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse((InputStream)new BufferedInputStream(inputStream), (HandlerBase)this);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ParseException("Error parsing: " + parserConfigurationException, 0);
            }
            catch (SAXException sAXException) {
                throw new ParseException("Error parsing: " + sAXException + " " + sAXException.getException(), 0);
            }
            catch (IOException iOException) {
                throw new ParseException("Error parsing: " + iOException, 0);
            }
        }
        finally {
            this.reset();
        }
    }

    private URL getResource(String string) {
        if (this._classResourceBase != null) {
            return this._classResourceBase.getResource(string);
        }
        try {
            return new URL(this._urlResourceBase, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void reset() {
        this._handler = null;
        this._depth = 0;
        this._mapping.clear();
        this._stateInfos.clear();
        this._colorTypes.clear();
        this._statePainters.clear();
        this._stylePainters.clear();
    }

    private boolean isForwarding() {
        return this._depth > 0;
    }

    private ObjectHandler getHandler() {
        if (this._handler == null) {
            if (this._urlResourceBase != null) {
                URL[] uRLArray = new URL[]{this.getResource(".")};
                ClassLoader object = Thread.currentThread().getContextClassLoader();
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, object);
                this._handler = new ObjectHandler(null, uRLClassLoader);
            } else {
                this._handler = new ObjectHandler(null, this._classResourceBase.getClassLoader());
            }
            for (String string : this._mapping.keySet()) {
                this._handler.register(string, this._mapping.get(string));
            }
        }
        return this._handler;
    }

    private Object checkCast(Object object, Class clazz) throws SAXException {
        if (!clazz.isInstance(object)) {
            throw new SAXException("Expected type " + clazz + " got " + object.getClass());
        }
        return object;
    }

    private Object lookup(String string, Class clazz) throws SAXException {
        Object object;
        if (this._handler != null && (object = this._handler.lookup(string)) != null) {
            return this.checkCast(object, clazz);
        }
        object = this._mapping.get(string);
        if (object == null) {
            throw new SAXException("ID " + string + " has not been defined");
        }
        return this.checkCast(object, clazz);
    }

    private void register(String string, Object object) throws SAXException {
        if (string != null) {
            if (this._mapping.get(string) != null || this._handler != null && this._handler.lookup(string) != null) {
                throw new SAXException("ID " + string + " is already defined");
            }
            if (this._handler != null) {
                this._handler.register(string, object);
            } else {
                this._mapping.put(string, object);
            }
        }
    }

    private int nextInt(StringTokenizer stringTokenizer, String string) throws SAXException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SAXException(string);
        }
        try {
            return Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(string);
        }
    }

    private Insets parseInsets(String string, String string2) throws SAXException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        return new Insets(this.nextInt(stringTokenizer, string2), this.nextInt(stringTokenizer, string2), this.nextInt(stringTokenizer, string2), this.nextInt(stringTokenizer, string2));
    }

    private void startStyle(AttributeList attributeList) throws SAXException {
        String string = null;
        this._style = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string2 = attributeList.getName(i);
            if (string2.equals(ATTRIBUTE_CLONE)) {
                this._style = (ParsedSynthStyle)((ParsedSynthStyle)this.lookup(attributeList.getValue(i), ParsedSynthStyle.class)).clone();
                continue;
            }
            if (!string2.equals(ATTRIBUTE_ID)) continue;
            string = attributeList.getValue(i);
        }
        if (this._style == null) {
            this._style = new ParsedSynthStyle();
        }
        this.register(string, this._style);
    }

    private void endStyle() throws SAXException {
        int n = this._stylePainters.size();
        if (n > 0) {
            this._style.setPainters(this._stylePainters.toArray(new ParsedSynthStyle.PainterInfo[n]));
            this._stylePainters.clear();
        }
        if ((n = this._stateInfos.size()) > 0) {
            this._style.setStateInfo(this._stateInfos.toArray(new ParsedSynthStyle.StateInfo[n]));
            this._stateInfos.clear();
        }
        this._style = null;
    }

    private void startState(AttributeList attributeList) throws SAXException {
        Object var2_2 = null;
        int n = 0;
        String string = null;
        this._stateInfo = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string2 = attributeList.getName(i);
            if (string2.equals(ATTRIBUTE_ID)) {
                string = attributeList.getValue(i);
                continue;
            }
            if (string2.equals(ATTRIBUTE_IDREF)) {
                this._stateInfo = (ParsedSynthStyle.StateInfo)this.lookup(attributeList.getValue(i), ParsedSynthStyle.StateInfo.class);
                continue;
            }
            if (string2.equals(ATTRIBUTE_CLONE)) {
                this._stateInfo = (ParsedSynthStyle.StateInfo)((ParsedSynthStyle.StateInfo)this.lookup(attributeList.getValue(i), ParsedSynthStyle.StateInfo.class)).clone();
                continue;
            }
            if (!string2.equals(ATTRIBUTE_VALUE)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(attributeList.getValue(i));
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken().toUpperCase().intern();
                if (string3 == "ENABLED") {
                    n |= 1;
                    continue;
                }
                if (string3 == "MOUSE_OVER") {
                    n |= 2;
                    continue;
                }
                if (string3 == "PRESSED") {
                    n |= 4;
                    continue;
                }
                if (string3 == "DISABLED") {
                    n |= 8;
                    continue;
                }
                if (string3 == "FOCUSED") {
                    n |= 0x100;
                    continue;
                }
                if (string3 == "SELECTED") {
                    n |= 0x200;
                    continue;
                }
                if (string3 == "DEFAULT") {
                    n |= 0x400;
                    continue;
                }
                if (string3 == "AND") continue;
                throw new SAXException("Unknown state: " + n);
            }
        }
        if (this._stateInfo == null) {
            this._stateInfo = new ParsedSynthStyle.StateInfo();
        }
        this._stateInfo.setComponentState(n);
        this.register(string, this._stateInfo);
        this._stateInfos.add(this._stateInfo);
    }

    private void endState() throws SAXException {
        int n = this._statePainters.size();
        if (n > 0) {
            this._stateInfo.setPainters(this._statePainters.toArray(new ParsedSynthStyle.PainterInfo[n]));
            this._statePainters.clear();
        }
        this._stateInfo = null;
    }

    private void startFont(AttributeList attributeList) throws SAXException {
        Font font = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        String string2 = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string3 = attributeList.getName(i);
            if (string3.equals(ATTRIBUTE_ID)) {
                string = attributeList.getValue(i);
                continue;
            }
            if (string3.equals(ATTRIBUTE_IDREF)) {
                font = (Font)this.lookup(attributeList.getValue(i), Font.class);
                continue;
            }
            if (string3.equals(ATTRIBUTE_NAME)) {
                string2 = attributeList.getValue(i);
                continue;
            }
            if (string3.equals(ATTRIBUTE_SIZE)) {
                try {
                    n2 = Integer.parseInt(attributeList.getValue(i));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("Invalid font size: " + attributeList.getValue(i));
                }
            }
            if (!string3.equals("style")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(attributeList.getValue(i));
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().intern();
                if (string4 == "BOLD") {
                    n = (n | 0) ^ 0 | 1;
                    continue;
                }
                if (string4 != "ITALIC") continue;
                n |= 2;
            }
        }
        if (font == null) {
            if (string2 == null) {
                throw new SAXException("You must define a name for the font");
            }
            if (n2 == 0) {
                throw new SAXException("You must define a size for the font");
            }
            font = new FontUIResource(string2, n, n2);
        } else if (string2 != null || n2 != 0 || n != 0) {
            throw new SAXException("Name, size and style are not for use with idref");
        }
        this.register(string, font);
        if (this._stateInfo != null) {
            this._stateInfo.setFont(font);
        } else if (this._style != null) {
            this._style.setFont(font);
        }
    }

    private void startColor(AttributeList attributeList) throws SAXException {
        Color color = null;
        String string = null;
        this._colorTypes.clear();
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            int n;
            Object object;
            String string2 = attributeList.getName(i);
            if (string2.equals(ATTRIBUTE_ID)) {
                string = attributeList.getValue(i);
                continue;
            }
            if (string2.equals(ATTRIBUTE_IDREF)) {
                color = (Color)this.lookup(attributeList.getValue(i), Color.class);
                continue;
            }
            if (string2.equals(ATTRIBUTE_NAME)) continue;
            if (string2.equals(ATTRIBUTE_VALUE)) {
                object = attributeList.getValue(i);
                if (((String)object).startsWith("#")) {
                    try {
                        int n2;
                        int n3 = ((String)object).length();
                        if (n3 < 8) {
                            n2 = Integer.decode((String)object);
                            n = 0;
                        } else if (n3 == 8) {
                            n2 = Integer.decode((String)object);
                            n = 1;
                        } else if (n3 == 9) {
                            int n4 = Integer.decode('#' + ((String)object).substring(3, 9));
                            int n5 = Integer.decode(((String)object).substring(0, 3));
                            n2 = n5 << 24 | n4;
                            n = 1;
                        } else {
                            throw new SAXException("Invalid Color value: " + (String)object);
                        }
                        color = new ColorUIResource(new Color(n2, n != 0));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Invalid Color value: " + (String)object);
                    }
                }
                try {
                    color = new ColorUIResource((Color)Color.class.getField(((String)object).toUpperCase()).get(Color.class));
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new SAXException("Invalid color name: " + (String)object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXException("Invalid color name: " + (String)object);
                }
            }
            if (!string2.equals(ATTRIBUTE_TYPE)) continue;
            object = new StringTokenizer(attributeList.getValue(i));
            while (((StringTokenizer)object).hasMoreTokens()) {
                Class clazz;
                String string3 = ((StringTokenizer)object).nextToken();
                n = string3.lastIndexOf(46);
                if (n == -1) {
                    clazz = ColorType.class;
                    n = 0;
                } else {
                    try {
                        clazz = Class.forName(string3.substring(0, n));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SAXException("Unknown class: " + string3.substring(0, n));
                    }
                    ++n;
                }
                try {
                    this._colorTypes.add((ColorType)this.checkCast(clazz.getField(string3.substring(n, string3.length() - n)).get(clazz), ColorType.class));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new SAXException("Unable to find color type: " + string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new SAXException("Unable to find color type: " + string3);
                }
            }
        }
        if (color == null) {
            throw new SAXException("color: you must specificy a value");
        }
        this.register(string, color);
        if (this._stateInfo != null && this._colorTypes.size() > 0) {
            Color[] colorArray = this._stateInfo.getColors();
            int n = 0;
            for (int i = this._colorTypes.size() - 1; i >= 0; --i) {
                n = Math.max(n, this._colorTypes.get(i).getID());
            }
            if (colorArray == null || colorArray.length <= n) {
                Color[] colorArray2 = new Color[n + 1];
                if (colorArray != null) {
                    System.arraycopy(colorArray, 0, colorArray2, 0, colorArray.length);
                }
                colorArray = colorArray2;
            }
            for (int i = this._colorTypes.size() - 1; i >= 0; --i) {
                colorArray[this._colorTypes.get((int)i).getID()] = color;
            }
            this._stateInfo.setColors(colorArray);
        }
    }

    private void startProperty(AttributeList attributeList, Object object) throws SAXException {
        Object object2 = null;
        String string = null;
        int n = 0;
        String string2 = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string3 = attributeList.getName(i);
            if (string3.equals(ATTRIBUTE_TYPE)) {
                String string4 = attributeList.getValue(i).toUpperCase();
                if (string4.equals("IDREF")) {
                    n = 0;
                    continue;
                }
                if (string4.equals("BOOLEAN")) {
                    n = 1;
                    continue;
                }
                if (string4.equals("DIMENSION")) {
                    n = 2;
                    continue;
                }
                if (string4.equals("INSETS")) {
                    n = 3;
                    continue;
                }
                if (string4.equals("INTEGER")) {
                    n = 4;
                    continue;
                }
                if (string4.equals("STRING")) {
                    n = 5;
                    continue;
                }
                throw new SAXException(object + " unknown type, use" + "idref, boolean, dimension, insets or integer");
            }
            if (string3.equals(ATTRIBUTE_VALUE)) {
                string2 = attributeList.getValue(i);
                continue;
            }
            if (!string3.equals(ATTRIBUTE_KEY)) continue;
            string = attributeList.getValue(i);
        }
        if (string2 != null) {
            switch (n) {
                case 0: {
                    object2 = this.lookup(string2, Object.class);
                    break;
                }
                case 1: {
                    if (string2.toUpperCase().equals("TRUE")) {
                        object2 = Boolean.TRUE;
                        break;
                    }
                    object2 = Boolean.FALSE;
                    break;
                }
                case 2: {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    object2 = new DimensionUIResource(this.nextInt(stringTokenizer, "Invalid dimension"), this.nextInt(stringTokenizer, "Invalid dimension"));
                    break;
                }
                case 3: {
                    object2 = this.parseInsets(string2, object + " invalid insets");
                    break;
                }
                case 4: {
                    try {
                        object2 = new Integer(Integer.parseInt(string2));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException(object + " invalid value");
                    }
                }
                case 5: {
                    object2 = string2;
                }
            }
        }
        if (object2 == null || string == null) {
            throw new SAXException(object + ": you must supply a " + "key and value");
        }
        if (object == ELEMENT_DEFAULTS_PROPERTY) {
            this._defaultsMap.put(string, object2);
        } else if (this._stateInfo != null) {
            if (this._stateInfo.getData() == null) {
                this._stateInfo.setData(new HashMap());
            }
            this._stateInfo.getData().put(string, object2);
        } else if (this._style != null) {
            if (this._style.getData() == null) {
                this._style.setData(new HashMap());
            }
            this._style.getData().put(string, object2);
        }
    }

    private void startGraphics(AttributeList attributeList) throws SAXException {
        SynthGraphicsUtils synthGraphicsUtils = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string = attributeList.getName(i);
            if (!string.equals(ATTRIBUTE_IDREF)) continue;
            synthGraphicsUtils = (SynthGraphicsUtils)this.lookup(attributeList.getValue(i), SynthGraphicsUtils.class);
        }
        if (synthGraphicsUtils == null) {
            throw new SAXException("graphicsUtils: you must supply an idref");
        }
        if (this._style != null) {
            this._style.setGraphicsUtils(synthGraphicsUtils);
        }
    }

    private void startInsets(AttributeList attributeList) throws SAXException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Insets insets = null;
        String string = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string2 = attributeList.getName(i);
            try {
                if (string2.equals(ATTRIBUTE_IDREF)) {
                    insets = (Insets)this.lookup(attributeList.getValue(i), Insets.class);
                    continue;
                }
                if (string2.equals(ATTRIBUTE_ID)) {
                    string = attributeList.getValue(i);
                    continue;
                }
                if (string2.equals(ATTRIBUTE_TOP)) {
                    n = Integer.parseInt(attributeList.getValue(i));
                    continue;
                }
                if (string2.equals(ATTRIBUTE_LEFT)) {
                    n3 = Integer.parseInt(attributeList.getValue(i));
                    continue;
                }
                if (string2.equals(ATTRIBUTE_BOTTOM)) {
                    n2 = Integer.parseInt(attributeList.getValue(i));
                    continue;
                }
                if (!string2.equals(ATTRIBUTE_RIGHT)) continue;
                n4 = Integer.parseInt(attributeList.getValue(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("insets: bad integer value for " + attributeList.getValue(i));
            }
        }
        if (insets == null) {
            insets = new InsetsUIResource(n, n3, n2, n4);
        }
        this.register(string, insets);
        if (this._style != null) {
            this._style.setInsets(insets);
        }
    }

    private void startBind(AttributeList attributeList) throws SAXException {
        ParsedSynthStyle parsedSynthStyle = null;
        String string = null;
        int n = -1;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string2 = attributeList.getName(i);
            if (string2.equals("style")) {
                parsedSynthStyle = (ParsedSynthStyle)this.lookup(attributeList.getValue(i), ParsedSynthStyle.class);
                continue;
            }
            if (string2.equals(ATTRIBUTE_TYPE)) {
                String string3 = attributeList.getValue(i).toUpperCase();
                if (string3.equals("NAME")) {
                    n = 0;
                    continue;
                }
                if (string3.equals("REGION")) {
                    n = 1;
                    continue;
                }
                throw new SAXException("bind: unknown type " + string3);
            }
            if (!string2.equals(ATTRIBUTE_KEY)) continue;
            string = attributeList.getValue(i);
        }
        if (parsedSynthStyle == null || string == null || n == -1) {
            throw new SAXException("bind: you must specify a style, type and key");
        }
        try {
            this._factory.addStyle(parsedSynthStyle, string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new SAXException("bind: " + string + " is not a valid " + "regular expression");
        }
    }

    private void startPainter(AttributeList attributeList, String string) throws SAXException {
        Insets insets = null;
        Insets insets2 = null;
        String string2 = null;
        boolean bl = true;
        boolean bl2 = true;
        SynthPainter synthPainter = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string5 = attributeList.getName(i);
            String string6 = attributeList.getValue(i);
            if (string5.equals(ATTRIBUTE_ID)) {
                string4 = string6;
                continue;
            }
            if (string5.equals(ATTRIBUTE_METHOD)) {
                string3 = string6.toLowerCase(Locale.ENGLISH);
                continue;
            }
            if (string5.equals(ATTRIBUTE_IDREF)) {
                synthPainter = (SynthPainter)this.lookup(string6, SynthPainter.class);
                continue;
            }
            if (string5.equals(ATTRIBUTE_PATH)) {
                string2 = string6;
                continue;
            }
            if (string5.equals(ATTRIBUTE_SOURCE_INSETS)) {
                insets = this.parseInsets(string6, string + ": sourceInsets must be top left bottom right");
                continue;
            }
            if (string5.equals(ATTRIBUTE_DEST_INSETS)) {
                insets2 = this.parseInsets(string6, string + ": destinationInsets must be top left bottom right");
                continue;
            }
            if (string5.equals(ATTRIBUTE_PAINT_CENTER)) {
                bl = string6.toLowerCase().equals("true");
                bl5 = true;
                continue;
            }
            if (string5.equals(ATTRIBUTE_STRETCH)) {
                bl2 = string6.toLowerCase().equals("true");
                bl4 = true;
                continue;
            }
            if (string5.equals(ATTRIBUTE_DIRECTION)) {
                if ((string6 = string6.toUpperCase().intern()) == "EAST") {
                    n = 3;
                    continue;
                }
                if (string6 == "NORTH") {
                    n = 1;
                    continue;
                }
                if (string6 == "SOUTH") {
                    n = 5;
                    continue;
                }
                if (string6 == "WEST") {
                    n = 7;
                    continue;
                }
                if (string6 == "TOP") {
                    n = 1;
                    continue;
                }
                if (string6 == "LEFT") {
                    n = 2;
                    continue;
                }
                if (string6 == "BOTTOM") {
                    n = 3;
                    continue;
                }
                if (string6 == "RIGHT") {
                    n = 4;
                    continue;
                }
                if (string6 == "HORIZONTAL") {
                    n = 0;
                    continue;
                }
                if (string6 == "VERTICAL") {
                    n = 1;
                    continue;
                }
                if (string6 == "HORIZONTAL_SPLIT") {
                    n = 1;
                    continue;
                }
                if (string6 == "VERTICAL_SPLIT") {
                    n = 0;
                    continue;
                }
                throw new SAXException(string + ": unknown direction");
            }
            if (!string5.equals(ATTRIBUTE_CENTER)) continue;
            bl3 = string6.toLowerCase().equals("true");
        }
        if (synthPainter == null) {
            if (string == ELEMENT_PAINTER) {
                throw new SAXException(string + ": you must specify an idref");
            }
            if (insets == null && !bl3) {
                throw new SAXException("property: you must specify sourceInsets");
            }
            if (string2 == null) {
                throw new SAXException("property: you must specify a path");
            }
            if (bl3 && (insets != null || insets2 != null || bl5 || bl4)) {
                throw new SAXException("The attributes: sourceInsets, destinationInsets, paintCenter and stretch  are not legal when center is true");
            }
            synthPainter = new ImagePainter(!bl2, bl, insets, insets2, this.getResource(string2), bl3);
        }
        this.register(string4, synthPainter);
        if (this._stateInfo != null) {
            this.addPainterOrMerge(this._statePainters, string3, synthPainter, n);
        } else if (this._style != null) {
            this.addPainterOrMerge(this._stylePainters, string3, synthPainter, n);
        }
    }

    private void addPainterOrMerge(List<ParsedSynthStyle.PainterInfo> list, String string, SynthPainter synthPainter, int n) {
        ParsedSynthStyle.PainterInfo painterInfo = new ParsedSynthStyle.PainterInfo(string, synthPainter, n);
        for (ParsedSynthStyle.PainterInfo painterInfo2 : list) {
            ParsedSynthStyle.PainterInfo painterInfo3 = painterInfo2;
            if (!painterInfo.equalsPainter(painterInfo3)) continue;
            painterInfo3.addPainter(synthPainter);
            return;
        }
        list.add(painterInfo);
    }

    private void startImageIcon(AttributeList attributeList) throws SAXException {
        String string = null;
        String string2 = null;
        for (int i = attributeList.getLength() - 1; i >= 0; --i) {
            String string3 = attributeList.getName(i);
            if (string3.equals(ATTRIBUTE_ID)) {
                string2 = attributeList.getValue(i);
                continue;
            }
            if (!string3.equals(ATTRIBUTE_PATH)) continue;
            string = attributeList.getValue(i);
        }
        if (string == null) {
            throw new SAXException("imageIcon: you must specify a path");
        }
        this.register(string2, new LazyImageIcon(this.getResource(string)));
    }

    private void startOpaque(AttributeList attributeList) throws SAXException {
        if (this._style != null) {
            this._style.setOpaque(true);
            for (int i = attributeList.getLength() - 1; i >= 0; --i) {
                String string = attributeList.getName(i);
                if (!string.equals(ATTRIBUTE_VALUE)) continue;
                this._style.setOpaque("true".equals(attributeList.getValue(i).toLowerCase()));
            }
        }
    }

    private void startInputMap(AttributeList attributeList) throws SAXException {
        this._inputMapBindings.clear();
        this._inputMapID = null;
        if (this._style != null) {
            for (int i = attributeList.getLength() - 1; i >= 0; --i) {
                String string = attributeList.getName(i);
                if (!string.equals(ATTRIBUTE_ID)) continue;
                this._inputMapID = attributeList.getValue(i);
            }
        }
    }

    private void endInputMap() throws SAXException {
        if (this._inputMapID != null) {
            this.register(this._inputMapID, new UIDefaults.LazyInputMap(this._inputMapBindings.toArray(new Object[this._inputMapBindings.size()])));
        }
        this._inputMapBindings.clear();
        this._inputMapID = null;
    }

    private void startBindKey(AttributeList attributeList) throws SAXException {
        if (this._inputMapID == null) {
            return;
        }
        if (this._style != null) {
            String string = null;
            String string2 = null;
            for (int i = attributeList.getLength() - 1; i >= 0; --i) {
                String string3 = attributeList.getName(i);
                if (string3.equals(ATTRIBUTE_KEY)) {
                    string = attributeList.getValue(i);
                    continue;
                }
                if (!string3.equals(ATTRIBUTE_ACTION)) continue;
                string2 = attributeList.getValue(i);
            }
            if (string == null || string2 == null) {
                throw new SAXException("bindKey: you must supply a key and action");
            }
            this._inputMapBindings.add(string);
            this._inputMapBindings.add(string2);
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.isForwarding()) {
            return this.getHandler().resolveEntity(string, string2);
        }
        return null;
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
        if (this.isForwarding()) {
            this.getHandler().notationDecl(string, string2, string3);
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.isForwarding()) {
            this.getHandler().unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.isForwarding()) {
            this.getHandler().setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().endDocument();
        }
    }

    @Override
    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if ((string = string.intern()) == "style") {
            this.startStyle(attributeList);
        } else if (string == ELEMENT_STATE) {
            this.startState(attributeList);
        } else if (string == ELEMENT_FONT) {
            this.startFont(attributeList);
        } else if (string == ELEMENT_COLOR) {
            this.startColor(attributeList);
        } else if (string == ELEMENT_PAINTER) {
            this.startPainter(attributeList, string);
        } else if (string == ELEMENT_IMAGE_PAINTER) {
            this.startPainter(attributeList, string);
        } else if (string == ELEMENT_PROPERTY) {
            this.startProperty(attributeList, ELEMENT_PROPERTY);
        } else if (string == ELEMENT_DEFAULTS_PROPERTY) {
            this.startProperty(attributeList, ELEMENT_DEFAULTS_PROPERTY);
        } else if (string == ELEMENT_SYNTH_GRAPHICS) {
            this.startGraphics(attributeList);
        } else if (string == ELEMENT_INSETS) {
            this.startInsets(attributeList);
        } else if (string == ELEMENT_BIND) {
            this.startBind(attributeList);
        } else if (string == ELEMENT_BIND_KEY) {
            this.startBindKey(attributeList);
        } else if (string == ELEMENT_IMAGE_ICON) {
            this.startImageIcon(attributeList);
        } else if (string == ELEMENT_OPAQUE) {
            this.startOpaque(attributeList);
        } else if (string == ELEMENT_INPUT_MAP) {
            this.startInputMap(attributeList);
        } else if (string != ELEMENT_SYNTH) {
            if (this._depth++ == 0) {
                this.getHandler().reset();
            }
            this.getHandler().startElement(string, attributeList);
        }
    }

    @Override
    public void endElement(String string) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().endElement(string);
            --this._depth;
            if (!this.isForwarding()) {
                this.getHandler().reset();
            }
        } else if ((string = string.intern()) == "style") {
            this.endStyle();
        } else if (string == ELEMENT_STATE) {
            this.endState();
        } else if (string == ELEMENT_INPUT_MAP) {
            this.endInputMap();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().characters(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().processingInstruction(string, string2);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().warning(sAXParseException);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().error(sAXParseException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.isForwarding()) {
            this.getHandler().fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    private static class LazyImageIcon
    extends ImageIcon
    implements UIResource {
        private URL location;

        public LazyImageIcon(URL uRL) {
            this.location = uRL;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.getImage() != null) {
                super.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            if (this.getImage() != null) {
                return super.getIconWidth();
            }
            return 0;
        }

        public int getIconHeight() {
            if (this.getImage() != null) {
                return super.getIconHeight();
            }
            return 0;
        }

        public Image getImage() {
            if (this.location != null) {
                this.setImage(Toolkit.getDefaultToolkit().getImage(this.location));
                this.location = null;
            }
            return super.getImage();
        }
    }
}

