/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XWindow;

class XWarningWindow
extends XWindow {
    static final int defaultHeight = 27;
    Window ownerWindow;

    XWarningWindow(Window window, long l) {
        super(window, l);
        this.ownerWindow = window;
        this.xSetVisible(true);
        this.toFront();
    }

    protected String getWMName() {
        return "Warning window";
    }

    public Graphics getGraphics() {
        if (this.surfaceData == null || this.ownerWindow == null) {
            return null;
        }
        return this.getGraphics(this.surfaceData, this.getColor(), this.getBackground(), this.getFont());
    }

    void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        String string = this.getWarningString();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        if (rectangle2.intersects(rectangle)) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            graphics.setClip(rectangle3);
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics.setColor(this.getColor());
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.stringWidth(string);
            int n6 = (rectangle.width - n5) / 2;
            int n7 = (rectangle.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
            graphics.drawString(string, n6, n7);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
    }

    String getWarningString() {
        return this.ownerWindow.getWarningString();
    }

    int getHeight() {
        return 27;
    }

    Color getBackground() {
        return SystemColor.window;
    }

    Color getColor() {
        return Color.black;
    }

    Font getFont() {
        return this.ownerWindow.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        Rectangle rectangle = this.getBounds();
        Graphics graphics = this.getGraphics();
        try {
            this.paint(graphics, 0, 0, rectangle.width, rectangle.height);
            Object var4_3 = null;
            graphics.dispose();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            graphics.dispose();
            throw throwable;
        }
    }

    public void handleExposeEvent(XEvent xEvent) {
        super.handleExposeEvent(xEvent);
        XExposeEvent xExposeEvent = xEvent.get_xexpose();
        final int n = xExposeEvent.get_x();
        final int n2 = xExposeEvent.get_y();
        final int n3 = xExposeEvent.get_width();
        final int n4 = xExposeEvent.get_height();
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Graphics graphics = XWarningWindow.this.getGraphics();
                try {
                    XWarningWindow.this.paint(graphics, n, n2, n3, n4);
                    Object var3_2 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        });
    }

    protected boolean isEventDisabled(XEvent xEvent) {
        return true;
    }
}

