/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class LaunchTool {
    private final ExecutionManager runtime;

    private LaunchTool(ExecutionManager executionManager) {
        this.runtime = executionManager;
    }

    private Connector selectConnector() {
        final JDialog jDialog = new JDialog();
        Container container = jDialog.getContentPane();
        JPanel jPanel = new JPanel();
        final ButtonGroup buttonGroup = new ButtonGroup();
        VirtualMachineManager virtualMachineManager = Bootstrap.virtualMachineManager();
        List<Connector> list = virtualMachineManager.allConnectors();
        HashMap<ButtonModel, Connector> hashMap = new HashMap<ButtonModel, Connector>(list.size(), 0.5f);
        jDialog.setModal(true);
        jDialog.setTitle("Select Connector Type");
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        for (Connector object2 : list) {
            JRadioButton jRadioButton = new JRadioButton(object2.description());
            hashMap.put(jRadioButton.getModel(), object2);
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }
        container.add(jPanel);
        Object object3 = new boolean[]{false};
        JPanel jPanel2 = this.okCancel(jDialog, new ActionListener((boolean[])object3){
            final /* synthetic */ boolean[] val$oked;
            {
                this.val$oked = blArray;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (buttonGroup.getSelection() == null) {
                    JOptionPane.showMessageDialog(jDialog, "Please select a connector type", "No Selection", 0);
                } else {
                    this.val$oked[0] = true;
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            }
        });
        container.add("South", jPanel2);
        jDialog.pack();
        jDialog.show();
        return object3[0] != false ? (Connector)hashMap.get(buttonGroup.getSelection()) : null;
    }

    private void configureAndConnect(final Connector connector) {
        final JDialog jDialog = new JDialog();
        final Map<String, Connector.Argument> map = connector.defaultArguments();
        jDialog.setModal(true);
        jDialog.setTitle("Connector Arguments");
        Container container = jDialog.getContentPane();
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, connector.description(), 1, 2);
        jPanel.setBorder(border);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        final ArrayList<StringArgRep> arrayList = new ArrayList<StringArgRep>(map.size());
        for (Connector.Argument argument : map.values()) {
            ArgRep argRep = argument instanceof Connector.BooleanArgument ? new BooleanArgRep((Connector.BooleanArgument)argument, jPanel) : new StringArgRep(argument, jPanel);
            arrayList.add((StringArgRep)argRep);
        }
        container.add(jPanel);
        JPanel jPanel2 = this.okCancel(jDialog, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (ArgRep argRep : arrayList) {
                    if (!argRep.isSpecified()) {
                        JOptionPane.showMessageDialog(jDialog, argRep.arg.label() + ": Argument must be specified", "No argument", 0);
                        return;
                    }
                    if (!argRep.isValid()) {
                        JOptionPane.showMessageDialog(jDialog, argRep.arg.label() + ": Bad argument value: " + argRep.getText(), "Bad argument", 0);
                        return;
                    }
                    argRep.install();
                }
                try {
                    if (LaunchTool.this.runtime.explictStart(connector, map)) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    } else {
                        JOptionPane.showMessageDialog(jDialog, "Bad arguments values: See diagnostics window.", "Bad arguments", 0);
                    }
                }
                catch (VMLaunchFailureException vMLaunchFailureException) {
                    JOptionPane.showMessageDialog(jDialog, "Launch Failure: " + vMLaunchFailureException, "Launch Failed", 0);
                }
            }
        });
        container.add("South", jPanel2);
        jDialog.pack();
        jDialog.show();
    }

    private JPanel okCancel(final JDialog jDialog, ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        return jPanel;
    }

    static void queryAndLaunchVM(ExecutionManager executionManager) throws VMLaunchFailureException {
        LaunchTool launchTool = new LaunchTool(executionManager);
        Connector connector = launchTool.selectConnector();
        if (connector != null) {
            launchTool.configureAndConnect(connector);
        }
    }

    private class BooleanArgRep
    extends ArgRep {
        final JCheckBox check;

        BooleanArgRep(Connector.BooleanArgument booleanArgument, JPanel jPanel) {
            super(booleanArgument);
            this.check = new JCheckBox(booleanArgument.label());
            this.check.setSelected(booleanArgument.booleanValue());
            this.panel.add(this.check);
            jPanel.add(this.panel);
        }

        String getText() {
            return ((Connector.BooleanArgument)this.arg).stringValueOf(this.check.getModel().isSelected());
        }
    }

    private class StringArgRep
    extends ArgRep {
        final JTextField textField;

        StringArgRep(Connector.Argument argument, JPanel jPanel) {
            super(argument);
            this.textField = new JTextField(argument.value(), 50);
            this.textField.setBorder(BorderFactory.createLoweredBevelBorder());
            this.panel.add(new JLabel(argument.label(), 4));
            this.panel.add(this.textField);
            jPanel.add(this.panel);
        }

        String getText() {
            return this.textField.getText();
        }
    }

    private abstract class ArgRep {
        final Connector.Argument arg;
        final JPanel panel;

        ArgRep(Connector.Argument argument) {
            this.arg = argument;
            this.panel = new JPanel();
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, argument.description(), 1, 2);
            this.panel.setBorder(titledBorder);
        }

        abstract String getText();

        boolean isValid() {
            return this.arg.isValid(this.getText());
        }

        boolean isSpecified() {
            String string = this.getText();
            return string != null && string.length() > 0 || !this.arg.mustSpecify();
        }

        void install() {
            this.arg.setValue(this.getText());
        }
    }
}

