/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.trace;

import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventThread
extends Thread {
    private final VirtualMachine vm;
    private final String[] excludes;
    private final PrintWriter writer;
    static String nextBaseIndent = "";
    private boolean connected = true;
    private boolean vmDied = true;
    private Map traceMap = new HashMap();

    EventThread(VirtualMachine virtualMachine, String[] stringArray, PrintWriter printWriter) {
        super("event-handler");
        this.vm = virtualMachine;
        this.excludes = stringArray;
        this.writer = printWriter;
    }

    public void run() {
        EventQueue eventQueue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = eventQueue.remove();
                EventIterator eventIterator = eventSet.eventIterator();
                while (eventIterator.hasNext()) {
                    this.handleEvent(eventIterator.nextEvent());
                }
                eventSet.resume();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.handleDisconnectedException();
                break;
            }
        }
    }

    void setEventRequests(boolean bl) {
        EventRequestManager eventRequestManager = this.vm.eventRequestManager();
        ExceptionRequest exceptionRequest = eventRequestManager.createExceptionRequest(null, true, true);
        exceptionRequest.setSuspendPolicy(2);
        exceptionRequest.enable();
        MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
        for (int i = 0; i < this.excludes.length; ++i) {
            methodEntryRequest.addClassExclusionFilter(this.excludes[i]);
        }
        methodEntryRequest.setSuspendPolicy(0);
        methodEntryRequest.enable();
        MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
        for (int i = 0; i < this.excludes.length; ++i) {
            methodExitRequest.addClassExclusionFilter(this.excludes[i]);
        }
        methodExitRequest.setSuspendPolicy(0);
        methodExitRequest.enable();
        ThreadDeathRequest threadDeathRequest = eventRequestManager.createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(2);
        threadDeathRequest.enable();
        if (bl) {
            ClassPrepareRequest classPrepareRequest = eventRequestManager.createClassPrepareRequest();
            for (int i = 0; i < this.excludes.length; ++i) {
                classPrepareRequest.addClassExclusionFilter(this.excludes[i]);
            }
            classPrepareRequest.setSuspendPolicy(2);
            classPrepareRequest.enable();
        }
    }

    ThreadTrace threadTrace(ThreadReference threadReference) {
        ThreadTrace threadTrace = (ThreadTrace)this.traceMap.get(threadReference);
        if (threadTrace == null) {
            threadTrace = new ThreadTrace(threadReference);
            this.traceMap.put(threadReference, threadTrace);
        }
        return threadTrace;
    }

    private void handleEvent(Event event) {
        if (event instanceof ExceptionEvent) {
            this.exceptionEvent((ExceptionEvent)event);
        } else if (event instanceof ModificationWatchpointEvent) {
            this.fieldWatchEvent((ModificationWatchpointEvent)event);
        } else if (event instanceof MethodEntryEvent) {
            this.methodEntryEvent((MethodEntryEvent)event);
        } else if (event instanceof MethodExitEvent) {
            this.methodExitEvent((MethodExitEvent)event);
        } else if (event instanceof StepEvent) {
            this.stepEvent((StepEvent)event);
        } else if (event instanceof ThreadDeathEvent) {
            this.threadDeathEvent((ThreadDeathEvent)event);
        } else if (event instanceof ClassPrepareEvent) {
            this.classPrepareEvent((ClassPrepareEvent)event);
        } else if (event instanceof VMStartEvent) {
            this.vmStartEvent((VMStartEvent)event);
        } else if (event instanceof VMDeathEvent) {
            this.vmDeathEvent((VMDeathEvent)event);
        } else if (event instanceof VMDisconnectEvent) {
            this.vmDisconnectEvent((VMDisconnectEvent)event);
        } else {
            throw new Error("Unexpected event type");
        }
    }

    synchronized void handleDisconnectedException() {
        EventQueue eventQueue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = eventQueue.remove();
                EventIterator eventIterator = eventSet.eventIterator();
                while (eventIterator.hasNext()) {
                    Event event = eventIterator.nextEvent();
                    if (event instanceof VMDeathEvent) {
                        this.vmDeathEvent((VMDeathEvent)event);
                        continue;
                    }
                    if (!(event instanceof VMDisconnectEvent)) continue;
                    this.vmDisconnectEvent((VMDisconnectEvent)event);
                }
                eventSet.resume();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void vmStartEvent(VMStartEvent vMStartEvent) {
        this.writer.println("-- VM Started --");
    }

    private void methodEntryEvent(MethodEntryEvent methodEntryEvent) {
        this.threadTrace(methodEntryEvent.thread()).methodEntryEvent(methodEntryEvent);
    }

    private void methodExitEvent(MethodExitEvent methodExitEvent) {
        this.threadTrace(methodExitEvent.thread()).methodExitEvent(methodExitEvent);
    }

    private void stepEvent(StepEvent stepEvent) {
        this.threadTrace(stepEvent.thread()).stepEvent(stepEvent);
    }

    private void fieldWatchEvent(ModificationWatchpointEvent modificationWatchpointEvent) {
        this.threadTrace(modificationWatchpointEvent.thread()).fieldWatchEvent(modificationWatchpointEvent);
    }

    void threadDeathEvent(ThreadDeathEvent threadDeathEvent) {
        ThreadTrace threadTrace = (ThreadTrace)this.traceMap.get(threadDeathEvent.thread());
        if (threadTrace != null) {
            threadTrace.threadDeathEvent(threadDeathEvent);
        }
    }

    private void classPrepareEvent(ClassPrepareEvent classPrepareEvent) {
        EventRequestManager eventRequestManager = this.vm.eventRequestManager();
        List<Field> list = classPrepareEvent.referenceType().visibleFields();
        for (Field field : list) {
            ModificationWatchpointRequest modificationWatchpointRequest = eventRequestManager.createModificationWatchpointRequest(field);
            for (int i = 0; i < this.excludes.length; ++i) {
                modificationWatchpointRequest.addClassExclusionFilter(this.excludes[i]);
            }
            modificationWatchpointRequest.setSuspendPolicy(0);
            modificationWatchpointRequest.enable();
        }
    }

    private void exceptionEvent(ExceptionEvent exceptionEvent) {
        ThreadTrace threadTrace = (ThreadTrace)this.traceMap.get(exceptionEvent.thread());
        if (threadTrace != null) {
            threadTrace.exceptionEvent(exceptionEvent);
        }
    }

    public void vmDeathEvent(VMDeathEvent vMDeathEvent) {
        this.vmDied = true;
        this.writer.println("-- The application exited --");
    }

    public void vmDisconnectEvent(VMDisconnectEvent vMDisconnectEvent) {
        this.connected = false;
        if (!this.vmDied) {
            this.writer.println("-- The application has been disconnected --");
        }
    }

    class ThreadTrace {
        final ThreadReference thread;
        final String baseIndent;
        static final String threadDelta = "                     ";
        StringBuffer indent;

        ThreadTrace(ThreadReference threadReference) {
            this.thread = threadReference;
            this.baseIndent = nextBaseIndent;
            this.indent = new StringBuffer(this.baseIndent);
            nextBaseIndent = nextBaseIndent + threadDelta;
            this.println("====== " + threadReference.name() + " ======");
        }

        private void println(String string) {
            EventThread.this.writer.print(this.indent);
            EventThread.this.writer.println(string);
        }

        void methodEntryEvent(MethodEntryEvent methodEntryEvent) {
            this.println(methodEntryEvent.method().name() + "  --  " + methodEntryEvent.method().declaringType().name());
            this.indent.append("| ");
        }

        void methodExitEvent(MethodExitEvent methodExitEvent) {
            this.indent.setLength(this.indent.length() - 2);
        }

        void fieldWatchEvent(ModificationWatchpointEvent modificationWatchpointEvent) {
            Field field = modificationWatchpointEvent.field();
            Value value = modificationWatchpointEvent.valueToBe();
            this.println("    " + field.name() + " = " + value);
        }

        void exceptionEvent(ExceptionEvent exceptionEvent) {
            this.println("Exception: " + exceptionEvent.exception() + " catch: " + exceptionEvent.catchLocation());
            EventRequestManager eventRequestManager = EventThread.this.vm.eventRequestManager();
            StepRequest stepRequest = eventRequestManager.createStepRequest(this.thread, -1, 1);
            stepRequest.addCountFilter(1);
            stepRequest.setSuspendPolicy(2);
            stepRequest.enable();
        }

        void stepEvent(StepEvent stepEvent) {
            int n = 0;
            this.indent = new StringBuffer(this.baseIndent);
            try {
                n = this.thread.frameCount();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
            while (n-- > 0) {
                this.indent.append("| ");
            }
            EventRequestManager eventRequestManager = EventThread.this.vm.eventRequestManager();
            eventRequestManager.deleteEventRequest(stepEvent.request());
        }

        void threadDeathEvent(ThreadDeathEvent threadDeathEvent) {
            this.indent = new StringBuffer(this.baseIndent);
            this.println("====== " + this.thread.name() + " end ======");
        }
    }
}

