/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.util.EncoderFactory;
import com.sun.codemodel.internal.util.UnicodeEscapeWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;

public abstract class CodeWriter {
    public abstract OutputStream openBinary(JPackage var1, String var2) throws IOException;

    public Writer openSource(JPackage jPackage, String string) throws IOException {
        final OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.openBinary(jPackage, string));
        try {
            return new UnicodeEscapeWriter(outputStreamWriter){
                private final CharsetEncoder encoder;
                {
                    super(writer);
                    this.encoder = EncoderFactory.createEncoder(outputStreamWriter.getEncoding());
                }

                protected boolean requireEscaping(int n) {
                    if (n < 32 && " \t\r\n".indexOf(n) == -1) {
                        return true;
                    }
                    if (n < 128) {
                        return false;
                    }
                    return !this.encoder.canEncode((char)n);
                }
            };
        }
        catch (Throwable throwable) {
            return new UnicodeEscapeWriter(outputStreamWriter);
        }
    }

    public abstract void close() throws IOException;
}

