/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.formats.html.AbstractExecutableMemberWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.formats.html.TagletOutputImpl;
import com.sun.tools.doclets.internal.toolkit.ConstructorWriter;
import com.sun.tools.doclets.internal.toolkit.MemberSummaryWriter;
import com.sun.tools.doclets.internal.toolkit.taglets.DeprecatedTaglet;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConstructorWriterImpl
extends AbstractExecutableMemberWriter
implements ConstructorWriter,
MemberSummaryWriter {
    private boolean foundNonPubConstructor = false;
    private boolean printedSummaryHeader = false;

    public ConstructorWriterImpl(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        super(subWriterHolderWriter, classDoc);
        VisibleMemberMap visibleMemberMap = new VisibleMemberMap(classDoc, 3, this.configuration().nodeprecated);
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>(visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!((ProgramElementDoc)arrayList.get(i)).isProtected() && !((ProgramElementDoc)arrayList.get(i)).isPrivate()) continue;
            this.setFoundNonPubConstructor(true);
        }
    }

    public ConstructorWriterImpl(SubWriterHolderWriter subWriterHolderWriter) {
        super(subWriterHolderWriter);
    }

    public void writeMemberSummaryHeader(ClassDoc classDoc) {
        this.printedSummaryHeader = true;
        this.writer.println();
        this.writer.println("<!-- ======== CONSTRUCTOR SUMMARY ======== -->");
        this.writer.println();
        this.writer.printSummaryHeader(this, classDoc);
    }

    public void writeMemberSummaryFooter(ClassDoc classDoc) {
        this.writer.printSummaryFooter(this, classDoc);
    }

    public void writeHeader(ClassDoc classDoc, String string) {
        this.writer.println();
        this.writer.println("<!-- ========= CONSTRUCTOR DETAIL ======== -->");
        this.writer.println();
        this.writer.anchor("constructor_detail");
        this.writer.printTableHeadingBackground(string);
    }

    public void writeConstructorHeader(ConstructorDoc constructorDoc, boolean bl) {
        if (!bl) {
            this.writer.printMemberHeader();
        }
        this.writer.println();
        String string = this.getErasureAnchor(constructorDoc);
        if (string != null) {
            this.writer.anchor(string);
        }
        this.writer.anchor(constructorDoc);
        this.writer.h3();
        this.writer.print(constructorDoc.name());
        this.writer.h3End();
    }

    public void writeSignature(ConstructorDoc constructorDoc) {
        this.writer.displayLength = 0;
        this.writer.pre();
        this.writer.writeAnnotationInfo(constructorDoc);
        this.printModifiers(constructorDoc);
        if (this.configuration().linksource) {
            this.writer.printSrcLink(constructorDoc, constructorDoc.name());
        } else {
            this.bold(constructorDoc.name());
        }
        this.writeParameters(constructorDoc);
        this.writeExceptions(constructorDoc);
        this.writer.preEnd();
        this.writer.dl();
    }

    public void writeDeprecated(ConstructorDoc constructorDoc) {
        String string = ((TagletOutputImpl)new DeprecatedTaglet().getTagletOutput(constructorDoc, this.writer.getTagletWriterInstance(false))).toString();
        if (string != null && string.trim().length() > 0) {
            this.writer.print(string);
        }
    }

    public void writeComments(ConstructorDoc constructorDoc) {
        if (constructorDoc.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment(constructorDoc);
        }
    }

    public void writeTags(ConstructorDoc constructorDoc) {
        this.writer.printTags(constructorDoc);
    }

    public void writeConstructorFooter() {
        this.writer.dlEnd();
    }

    public void writeFooter(ClassDoc classDoc) {
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void setFoundNonPubConstructor(boolean bl) {
        this.foundNonPubConstructor = bl;
    }

    public void printSummaryLabel(ClassDoc classDoc) {
        this.writer.boldText("doclet.Constructor_Summary");
    }

    public void printSummaryAnchor(ClassDoc classDoc) {
        this.writer.anchor("constructor_summary");
    }

    public void printInheritedSummaryAnchor(ClassDoc classDoc) {
    }

    public void printInheritedSummaryLabel(ClassDoc classDoc) {
    }

    public int getMemberKind() {
        return 3;
    }

    protected void navSummaryLink(List list) {
        this.printNavSummaryLink(this.classdoc, list.size() > 0);
    }

    protected void printNavSummaryLink(ClassDoc classDoc, boolean bl) {
        if (bl) {
            this.writer.printHyperLink("", "constructor_summary", ConfigurationImpl.getInstance().getText("doclet.navConstructor"));
        } else {
            this.writer.printText("doclet.navConstructor");
        }
    }

    protected void printNavDetailLink(boolean bl) {
        if (bl) {
            this.writer.printHyperLink("", "constructor_detail", ConfigurationImpl.getInstance().getText("doclet.navConstructor"));
        } else {
            this.writer.printText("doclet.navConstructor");
        }
    }

    protected void printSummaryType(ProgramElementDoc programElementDoc) {
        if (this.foundNonPubConstructor) {
            this.writer.printTypeSummaryHeader();
            if (programElementDoc.isProtected()) {
                this.print("protected ");
            } else if (programElementDoc.isPrivate()) {
                this.print("private ");
            } else if (programElementDoc.isPublic()) {
                this.writer.space();
            } else {
                this.writer.printText("doclet.Package_private");
            }
            this.writer.printTypeSummaryFooter();
        }
    }

    public void writeInheritedMemberSummaryHeader(ClassDoc classDoc) {
        if (!this.printedSummaryHeader) {
            this.writeMemberSummaryHeader(classDoc);
            this.writeMemberSummaryFooter(classDoc);
            this.printedSummaryHeader = true;
        }
    }

    public void writeInheritedMemberSummary(ClassDoc classDoc, ProgramElementDoc programElementDoc, boolean bl, boolean bl2) {
    }

    public void writeInheritedMemberSummaryFooter(ClassDoc classDoc) {
    }
}

