/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaObjectRef;
import com.sun.tools.hat.internal.model.JavaStatic;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.Root;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import com.sun.tools.hat.internal.util.CompositeEnumeration;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
extends JavaHeapObject {
    private long id;
    private String name;
    private JavaThing superclass;
    private JavaThing loader;
    private JavaThing signers;
    private JavaThing protectionDomain;
    private JavaField[] fields;
    private JavaStatic[] statics;
    private static final JavaClass[] EMPTY_CLASS_ARRAY = new JavaClass[0];
    private JavaClass[] subclasses = EMPTY_CLASS_ARRAY;
    private Vector<JavaHeapObject> instances = new Vector();
    private Snapshot mySnapshot;
    private int instanceSize;
    private int totalNumFields;

    public JavaClass(long l, String string, long l2, long l3, long l4, long l5, JavaField[] javaFieldArray, JavaStatic[] javaStaticArray, int n) {
        this.id = l;
        this.name = string;
        this.superclass = new JavaObjectRef(l2);
        this.loader = new JavaObjectRef(l3);
        this.signers = new JavaObjectRef(l4);
        this.protectionDomain = new JavaObjectRef(l5);
        this.fields = javaFieldArray;
        this.statics = javaStaticArray;
        this.instanceSize = n;
    }

    public JavaClass(String string, long l, long l2, long l3, long l4, JavaField[] javaFieldArray, JavaStatic[] javaStaticArray, int n) {
        this(-1L, string, l, l2, l3, l4, javaFieldArray, javaStaticArray, n);
    }

    @Override
    public final JavaClass getClazz() {
        return this.mySnapshot.getJavaLangClass();
    }

    public final int getIdentifierSize() {
        return this.mySnapshot.getIdentifierSize();
    }

    public final int getMinimumObjectSize() {
        return this.mySnapshot.getMinimumObjectSize();
    }

    @Override
    public void resolve(Snapshot snapshot) {
        if (this.mySnapshot != null) {
            return;
        }
        this.mySnapshot = snapshot;
        this.resolveSuperclass(snapshot);
        if (this.superclass != null) {
            ((JavaClass)this.superclass).addSubclass(this);
        }
        this.loader = this.loader.dereference(snapshot, null);
        this.signers = this.signers.dereference(snapshot, null);
        this.protectionDomain = this.protectionDomain.dereference(snapshot, null);
        for (int i = 0; i < this.statics.length; ++i) {
            this.statics[i].resolve(this, snapshot);
        }
        snapshot.getJavaLangClass().addInstance(this);
        super.resolve(snapshot);
    }

    public void resolveSuperclass(Snapshot snapshot) {
        if (this.superclass != null) {
            this.totalNumFields = this.fields.length;
            this.superclass = this.superclass.dereference(snapshot, null);
            if (this.superclass == snapshot.getNullThing()) {
                this.superclass = null;
            } else {
                try {
                    JavaClass javaClass = (JavaClass)this.superclass;
                    javaClass.resolveSuperclass(snapshot);
                    this.totalNumFields += javaClass.totalNumFields;
                }
                catch (ClassCastException classCastException) {
                    System.out.println("Warning!  Superclass of " + this.name + " is " + this.superclass);
                    this.superclass = null;
                }
            }
        }
    }

    public boolean isString() {
        return this.mySnapshot.getJavaLangString() == this;
    }

    public boolean isClassLoader() {
        return this.mySnapshot.getJavaLangClassLoader().isAssignableFrom(this);
    }

    public JavaField getField(int n) {
        if (n < 0 || n >= this.fields.length) {
            throw new Error("No field " + n + " for " + this.name);
        }
        return this.fields[n];
    }

    public int getNumFieldsForInstance() {
        return this.totalNumFields;
    }

    public JavaField getFieldForInstance(int n) {
        if (this.superclass != null) {
            JavaClass javaClass = (JavaClass)this.superclass;
            if (n < javaClass.totalNumFields) {
                return javaClass.getFieldForInstance(n);
            }
            n -= javaClass.totalNumFields;
        }
        return this.getField(n);
    }

    public JavaClass getClassForField(int n) {
        if (this.superclass != null) {
            JavaClass javaClass = (JavaClass)this.superclass;
            if (n < javaClass.totalNumFields) {
                return javaClass.getClassForField(n);
            }
        }
        return this;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.name.indexOf(91) != -1;
    }

    public Enumeration getInstances(boolean bl) {
        if (bl) {
            CompositeEnumeration compositeEnumeration = this.instances.elements();
            for (int i = 0; i < this.subclasses.length; ++i) {
                compositeEnumeration = new CompositeEnumeration(compositeEnumeration, this.subclasses[i].getInstances(true));
            }
            return compositeEnumeration;
        }
        return this.instances.elements();
    }

    public int getInstancesCount(boolean bl) {
        int n = this.instances.size();
        if (bl) {
            for (int i = 0; i < this.subclasses.length; ++i) {
                n += this.subclasses[i].getInstancesCount(bl);
            }
        }
        return n;
    }

    public JavaClass[] getSubclasses() {
        return this.subclasses;
    }

    public JavaClass getSuperclass() {
        return (JavaClass)this.superclass;
    }

    public JavaThing getLoader() {
        return this.loader;
    }

    public boolean isBootstrap() {
        return this.loader == this.mySnapshot.getNullThing();
    }

    public JavaThing getSigners() {
        return this.signers;
    }

    public JavaThing getProtectionDomain() {
        return this.protectionDomain;
    }

    public JavaField[] getFields() {
        return this.fields;
    }

    public JavaField[] getFieldsForInstance() {
        Vector<JavaField> vector = new Vector<JavaField>();
        this.addFields(vector);
        JavaField[] javaFieldArray = new JavaField[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            javaFieldArray[i] = vector.elementAt(i);
        }
        return javaFieldArray;
    }

    public JavaStatic[] getStatics() {
        return this.statics;
    }

    public JavaThing getStaticField(String string) {
        for (int i = 0; i < this.statics.length; ++i) {
            JavaStatic javaStatic = this.statics[i];
            if (!javaStatic.getField().getName().equals(string)) continue;
            return javaStatic.getValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return "class " + this.name;
    }

    @Override
    public int compareTo(JavaThing javaThing) {
        if (javaThing instanceof JavaClass) {
            return this.name.compareTo(((JavaClass)javaThing).name);
        }
        return super.compareTo(javaThing);
    }

    public boolean isAssignableFrom(JavaClass javaClass) {
        if (this == javaClass) {
            return true;
        }
        if (javaClass == null) {
            return false;
        }
        return this.isAssignableFrom((JavaClass)javaClass.superclass);
    }

    @Override
    public String describeReferenceTo(JavaThing javaThing, Snapshot snapshot) {
        for (int i = 0; i < this.statics.length; ++i) {
            JavaThing javaThing2;
            JavaField javaField = this.statics[i].getField();
            if (!javaField.hasId() || (javaThing2 = this.statics[i].getValue()) != javaThing) continue;
            return "static field " + javaField.getName();
        }
        return super.describeReferenceTo(javaThing, snapshot);
    }

    public int getInstanceSize() {
        return this.instanceSize + this.mySnapshot.getMinimumObjectSize();
    }

    public long getTotalInstanceSize() {
        int n = this.instances.size();
        if (n == 0 || !this.isArray()) {
            return n * this.instanceSize;
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            JavaThing javaThing = this.instances.elementAt(i);
            l += (long)javaThing.getSize();
        }
        return l;
    }

    @Override
    public int getSize() {
        JavaClass javaClass = this.mySnapshot.getJavaLangClass();
        if (javaClass == null) {
            return 0;
        }
        return javaClass.getInstanceSize();
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor javaHeapObjectVisitor) {
        JavaThing javaThing;
        super.visitReferencedObjects(javaHeapObjectVisitor);
        JavaClass javaClass = this.getSuperclass();
        if (javaClass != null) {
            javaHeapObjectVisitor.visit(this.getSuperclass());
        }
        if ((javaThing = this.getLoader()) instanceof JavaHeapObject) {
            javaHeapObjectVisitor.visit((JavaHeapObject)javaThing);
        }
        if ((javaThing = this.getSigners()) instanceof JavaHeapObject) {
            javaHeapObjectVisitor.visit((JavaHeapObject)javaThing);
        }
        if ((javaThing = this.getProtectionDomain()) instanceof JavaHeapObject) {
            javaHeapObjectVisitor.visit((JavaHeapObject)javaThing);
        }
        for (int i = 0; i < this.statics.length; ++i) {
            JavaField javaField = this.statics[i].getField();
            if (javaHeapObjectVisitor.exclude(this, javaField) || !javaField.hasId() || !((javaThing = this.statics[i].getValue()) instanceof JavaHeapObject)) continue;
            javaHeapObjectVisitor.visit((JavaHeapObject)javaThing);
        }
    }

    final ReadBuffer getReadBuffer() {
        return this.mySnapshot.getReadBuffer();
    }

    final void setNew(JavaHeapObject javaHeapObject, boolean bl) {
        this.mySnapshot.setNew(javaHeapObject, bl);
    }

    final boolean isNew(JavaHeapObject javaHeapObject) {
        return this.mySnapshot.isNew(javaHeapObject);
    }

    final StackTrace getSiteTrace(JavaHeapObject javaHeapObject) {
        return this.mySnapshot.getSiteTrace(javaHeapObject);
    }

    final void addReferenceFromRoot(Root root, JavaHeapObject javaHeapObject) {
        this.mySnapshot.addReferenceFromRoot(root, javaHeapObject);
    }

    final Root getRoot(JavaHeapObject javaHeapObject) {
        return this.mySnapshot.getRoot(javaHeapObject);
    }

    final Snapshot getSnapshot() {
        return this.mySnapshot;
    }

    void addInstance(JavaHeapObject javaHeapObject) {
        this.instances.addElement(javaHeapObject);
    }

    private void addFields(Vector<JavaField> vector) {
        if (this.superclass != null) {
            ((JavaClass)this.superclass).addFields(vector);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            vector.addElement(this.fields[i]);
        }
    }

    private void addSubclassInstances(Vector<JavaHeapObject> vector) {
        int n;
        for (n = 0; n < this.subclasses.length; ++n) {
            this.subclasses[n].addSubclassInstances(vector);
        }
        for (n = 0; n < this.instances.size(); ++n) {
            vector.addElement(this.instances.elementAt(n));
        }
    }

    private void addSubclass(JavaClass javaClass) {
        JavaClass[] javaClassArray = new JavaClass[this.subclasses.length + 1];
        System.arraycopy(this.subclasses, 0, javaClassArray, 0, this.subclasses.length);
        javaClassArray[this.subclasses.length] = javaClass;
        this.subclasses = javaClassArray;
    }
}

