/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.oql.OQLEngine;
import com.sun.tools.hat.internal.server.AllClassesQuery;
import com.sun.tools.hat.internal.server.AllRootsQuery;
import com.sun.tools.hat.internal.server.ClassQuery;
import com.sun.tools.hat.internal.server.FinalizerObjectsQuery;
import com.sun.tools.hat.internal.server.FinalizerSummaryQuery;
import com.sun.tools.hat.internal.server.HistogramQuery;
import com.sun.tools.hat.internal.server.InstancesCountQuery;
import com.sun.tools.hat.internal.server.InstancesQuery;
import com.sun.tools.hat.internal.server.OQLHelp;
import com.sun.tools.hat.internal.server.OQLQuery;
import com.sun.tools.hat.internal.server.ObjectQuery;
import com.sun.tools.hat.internal.server.QueryHandler;
import com.sun.tools.hat.internal.server.ReachableQuery;
import com.sun.tools.hat.internal.server.RefsByTypeQuery;
import com.sun.tools.hat.internal.server.RootStackQuery;
import com.sun.tools.hat.internal.server.RootsQuery;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URLDecoder;

public class HttpReader
implements Runnable {
    private Socket socket;
    private PrintWriter out;
    private Snapshot snapshot;
    private OQLEngine engine;

    public HttpReader(Socket socket, Snapshot snapshot, OQLEngine oQLEngine) {
        this.socket = socket;
        this.snapshot = snapshot;
        this.engine = oQLEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(this.socket.getInputStream());
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())));
            this.out.println("HTTP/1.0 200 OK");
            this.out.println("Cache-Control: no-cache");
            this.out.println("Pragma: no-cache");
            this.out.println();
            if (((InputStream)bufferedInputStream).read() != 71 || ((InputStream)bufferedInputStream).read() != 69 || ((InputStream)bufferedInputStream).read() != 84 || ((InputStream)bufferedInputStream).read() != 32) {
                this.outputError("Protocol error");
            }
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = ((InputStream)bufferedInputStream).read()) != -1 && n != 32) {
                char c = (char)n;
                stringBuffer.append(c);
            }
            String string = stringBuffer.toString();
            string = URLDecoder.decode(string, "UTF-8");
            QueryHandler queryHandler = null;
            if (this.snapshot == null) {
                this.outputError("The heap snapshot is still being read.");
                return;
            }
            if (string.equals("/")) {
                queryHandler = new AllClassesQuery(true, this.engine != null);
                queryHandler.setUrlStart("");
                queryHandler.setQuery("");
            } else if (string.startsWith("/oql/")) {
                if (this.engine != null) {
                    queryHandler = new OQLQuery(this.engine);
                    queryHandler.setUrlStart("");
                    queryHandler.setQuery(string.substring(5));
                }
            } else if (string.startsWith("/oqlhelp/")) {
                if (this.engine != null) {
                    queryHandler = new OQLHelp();
                    queryHandler.setUrlStart("");
                    queryHandler.setQuery("");
                }
            } else if (string.equals("/allClassesWithPlatform/")) {
                queryHandler = new AllClassesQuery(false, this.engine != null);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery("");
            } else if (string.equals("/showRoots/")) {
                queryHandler = new AllRootsQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery("");
            } else if (string.equals("/showInstanceCounts/includePlatform/")) {
                queryHandler = new InstancesCountQuery(false);
                queryHandler.setUrlStart("../../");
                queryHandler.setQuery("");
            } else if (string.equals("/showInstanceCounts/")) {
                queryHandler = new InstancesCountQuery(true);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery("");
            } else if (string.startsWith("/instances/")) {
                queryHandler = new InstancesQuery(false);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(11));
            } else if (string.startsWith("/newInstances/")) {
                queryHandler = new InstancesQuery(false, true);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(14));
            } else if (string.startsWith("/allInstances/")) {
                queryHandler = new InstancesQuery(true);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(14));
            } else if (string.startsWith("/allNewInstances/")) {
                queryHandler = new InstancesQuery(true, true);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(17));
            } else if (string.startsWith("/object/")) {
                queryHandler = new ObjectQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(8));
            } else if (string.startsWith("/class/")) {
                queryHandler = new ClassQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(7));
            } else if (string.startsWith("/roots/")) {
                queryHandler = new RootsQuery(false);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(7));
            } else if (string.startsWith("/allRoots/")) {
                queryHandler = new RootsQuery(true);
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(10));
            } else if (string.startsWith("/reachableFrom/")) {
                queryHandler = new ReachableQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(15));
            } else if (string.startsWith("/rootStack/")) {
                queryHandler = new RootStackQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(11));
            } else if (string.startsWith("/histo/")) {
                queryHandler = new HistogramQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(7));
            } else if (string.startsWith("/refsByType/")) {
                queryHandler = new RefsByTypeQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery(string.substring(12));
            } else if (string.startsWith("/finalizerSummary/")) {
                queryHandler = new FinalizerSummaryQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery("");
            } else if (string.startsWith("/finalizerObjects/")) {
                queryHandler = new FinalizerObjectsQuery();
                queryHandler.setUrlStart("../");
                queryHandler.setQuery("");
            }
            if (queryHandler != null) {
                queryHandler.setOutput(this.out);
                queryHandler.setSnapshot(this.snapshot);
                queryHandler.run();
            } else {
                this.outputError("Query '" + string + "' not implemented");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {}
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void outputError(String string) {
        this.out.println();
        this.out.println("<html><body bgcolor=\"#ffffff\">");
        this.out.println(string);
        this.out.println("</body></html>");
    }
}

