/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.internal.jxc.Messages;
import com.sun.tools.internal.jxc.apt.Options;
import com.sun.tools.internal.xjc.BadCommandLineException;
import com.sun.tools.internal.xjc.api.util.APTClassLoader;
import com.sun.tools.internal.xjc.api.util.ToolsJarNotFoundException;
import com.sun.xml.internal.bind.util.Which;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private static final String[] packagePrefixes = new String[]{"com.sun.tools.internal.jxc.", "com.sun.tools.internal.xjc.", "com.sun.istack.internal.tools.", "com.sun.tools.apt.", "com.sun.tools.javac.", "com.sun.tools.javadoc.", "com.sun.mirror."};

    public static void main(String[] stringArray) throws Exception {
        System.exit(SchemaGenerator.run(stringArray));
    }

    public static int run(String[] stringArray) throws Exception {
        try {
            ClassLoader classLoader = SchemaGenerator.class.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            APTClassLoader aPTClassLoader = new APTClassLoader(classLoader, packagePrefixes);
            return SchemaGenerator.run(stringArray, aPTClassLoader);
        }
        catch (ToolsJarNotFoundException toolsJarNotFoundException) {
            System.err.println(toolsJarNotFoundException.getMessage());
            return -1;
        }
    }

    public static int run(String[] stringArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File file;
        Options options = new Options();
        if (stringArray.length == 0) {
            SchemaGenerator.usage();
            return -1;
        }
        for (String object2 : stringArray) {
            if (object2.equals("-help")) {
                SchemaGenerator.usage();
                return -1;
            }
            if (!object2.equals("-version")) continue;
            System.out.println(Messages.VERSION.format(new Object[0]));
            return -1;
        }
        try {
            options.parseArguments(stringArray);
        }
        catch (BadCommandLineException badCommandLineException) {
            System.out.println(badCommandLineException.getMessage());
            System.out.println();
            SchemaGenerator.usage();
            return -1;
        }
        Class<?> clazz = classLoader.loadClass(Runner.class.getName());
        Method method = clazz.getDeclaredMethod("main", String[].class);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (SchemaGenerator.hasClass(options.arguments)) {
            arrayList.add("-XclassesAsDecls");
        }
        if ((file = SchemaGenerator.findJaxbApiJar()) != null) {
            options.classpath = options.classpath != null ? options.classpath + File.pathSeparatorChar + file : file.getPath();
        }
        arrayList.add("-cp");
        arrayList.add(options.classpath);
        if (options.targetDir != null) {
            arrayList.add("-d");
            arrayList.add(options.targetDir.getPath());
        }
        arrayList.addAll(options.arguments);
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        return (Integer)method.invoke(null, new Object[]{stringArray2});
    }

    private static File findJaxbApiJar() {
        String string = Which.which(JAXBContext.class);
        if (string == null) {
            return null;
        }
        if (!string.startsWith("jar:") || string.lastIndexOf(33) == -1) {
            return null;
        }
        String string2 = string.substring(4, string.lastIndexOf(33));
        if (!string2.startsWith("file:")) {
            return null;
        }
        try {
            File file = new File(new URL(string2).getFile());
            if (file.exists() && file.getName().endsWith(".jar")) {
                return file;
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static boolean hasClass(List<String> list) {
        for (String string : list) {
            if (string.endsWith(".java")) continue;
            return true;
        }
        return false;
    }

    private static void usage() {
        System.out.println(Messages.USAGE.format(new Object[0]));
    }

    public static final class Runner {
        public static int main(String[] stringArray) throws Exception {
            ClassLoader classLoader = Runner.class.getClassLoader();
            Class<?> clazz = classLoader.loadClass("com.sun.tools.apt.Main");
            Method method = clazz.getMethod("process", AnnotationProcessorFactory.class, String[].class);
            return (Integer)method.invoke(null, new com.sun.tools.internal.jxc.apt.SchemaGenerator(), stringArray);
        }
    }
}

