/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.annotation;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.modeler.JavaSimpleTypeCreator;
import com.sun.tools.internal.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.internal.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.internal.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.internal.ws.util.ClassNameInfo;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.internal.ws.wsdl.document.soap.SOAPUse;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.xml.internal.ws.modeler.RuntimeModeler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.jws.HandlerChain;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;

public abstract class WebServiceVisitor
extends SimpleDeclarationVisitor
implements WebServiceConstants {
    protected ModelBuilder builder;
    protected String wsdlNamespace;
    protected String typeNamespace;
    protected Stack<SOAPBinding> soapBindingStack;
    protected SOAPBinding typeDeclSOAPBinding;
    protected SOAPUse soapUse = SOAPUse.LITERAL;
    protected SOAPStyle soapStyle = SOAPStyle.DOCUMENT;
    protected boolean wrapped = true;
    protected HandlerChain hChain;
    protected Port port;
    protected String serviceImplName;
    protected String endpointInterfaceName;
    protected AnnotationProcessorContext context;
    protected AnnotationProcessorContext.SEIContext seiContext;
    protected boolean processingSEI = false;
    protected String serviceName;
    protected String packageName;
    protected String portName;
    protected boolean endpointReferencesInterface = false;
    protected boolean hasWebMethods = false;
    protected JavaSimpleTypeCreator simpleTypeCreator;
    protected TypeDeclaration typeDecl;
    protected Set<String> processedMethods;
    protected boolean pushedSOAPBinding = false;
    protected static final String ANNOTATION_ELEMENT_ERROR = "webserviceap.endpointinteface.plus.element";

    public WebServiceVisitor(ModelBuilder modelBuilder, AnnotationProcessorContext annotationProcessorContext) {
        this.builder = modelBuilder;
        this.context = annotationProcessorContext;
        this.simpleTypeCreator = new JavaSimpleTypeCreator();
        this.soapBindingStack = new Stack();
        this.processedMethods = new HashSet<String>();
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration interfaceDeclaration) {
        WebService webService = interfaceDeclaration.getAnnotation(WebService.class);
        if (!this.shouldProcessWebService(webService, interfaceDeclaration)) {
            return;
        }
        if (this.builder.checkAndSetProcessed(interfaceDeclaration)) {
            return;
        }
        this.typeDecl = interfaceDeclaration;
        if (this.endpointInterfaceName != null && !this.endpointInterfaceName.equals(interfaceDeclaration.getQualifiedName())) {
            this.builder.onError(interfaceDeclaration.getPosition(), "webserviceap.endpointinterfaces.do.not.match", new Object[]{this.endpointInterfaceName, interfaceDeclaration.getQualifiedName()});
        }
        this.verifySEIAnnotations(webService, interfaceDeclaration);
        this.endpointInterfaceName = interfaceDeclaration.getQualifiedName();
        this.processingSEI = true;
        this.preProcessWebService(webService, interfaceDeclaration);
        this.processWebService(webService, interfaceDeclaration);
        this.postProcessWebService(webService, interfaceDeclaration);
    }

    public void visitClassDeclaration(ClassDeclaration classDeclaration) {
        String string;
        WebService webService = classDeclaration.getAnnotation(WebService.class);
        if (!this.shouldProcessWebService(webService, classDeclaration)) {
            return;
        }
        if (this.builder.checkAndSetProcessed(classDeclaration)) {
            return;
        }
        this.typeDeclSOAPBinding = classDeclaration.getAnnotation(SOAPBinding.class);
        this.typeDecl = classDeclaration;
        if (this.serviceImplName == null) {
            this.serviceImplName = classDeclaration.getQualifiedName();
        }
        String string2 = string = webService != null ? webService.endpointInterface() : null;
        if (string != null && string.length() > 0) {
            SourcePosition sourcePosition = classDeclaration.getPosition();
            this.checkForInvalidImplAnnotation(classDeclaration, SOAPBinding.class);
            if (webService.name().length() > 0) {
                this.annotationError(sourcePosition, ANNOTATION_ELEMENT_ERROR, "name");
            }
            this.endpointReferencesInterface = true;
            this.verifyImplAnnotations(classDeclaration);
            this.inspectEndpointInterface(string, classDeclaration);
            this.serviceImplName = null;
            return;
        }
        this.processingSEI = false;
        this.preProcessWebService(webService, classDeclaration);
        this.processWebService(webService, classDeclaration);
        this.serviceImplName = null;
        this.postProcessWebService(webService, classDeclaration);
        this.serviceImplName = null;
    }

    protected void verifySEIAnnotations(WebService webService, InterfaceDeclaration interfaceDeclaration) {
        if (webService.endpointInterface().length() > 0) {
            this.builder.onError(interfaceDeclaration.getPosition(), "webservicefactory.endpointinterface.on.interface", new Object[]{interfaceDeclaration.getQualifiedName(), webService.endpointInterface()});
        }
        if (webService.serviceName().length() > 0) {
            this.builder.onError(interfaceDeclaration.getPosition(), "webserviceap.invalid.sei.annotation.element", new Object[]{"serviceName", interfaceDeclaration.getQualifiedName()});
        }
        if (webService.portName().length() > 0) {
            this.builder.onError(interfaceDeclaration.getPosition(), "webserviceap.invalid.sei.annotation.element", new Object[]{"portName", interfaceDeclaration.getQualifiedName()});
        }
    }

    protected void verifyImplAnnotations(ClassDeclaration classDeclaration) {
        for (MethodDeclaration methodDeclaration : classDeclaration.getMethods()) {
            this.checkForInvalidImplAnnotation(methodDeclaration, WebMethod.class);
            this.checkForInvalidImplAnnotation(methodDeclaration, Oneway.class);
            this.checkForInvalidImplAnnotation(methodDeclaration, WebResult.class);
            for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
                this.checkForInvalidImplAnnotation(parameterDeclaration, WebParam.class);
            }
        }
    }

    protected void checkForInvalidSEIAnnotation(InterfaceDeclaration interfaceDeclaration, Class clazz) {
        Object a = interfaceDeclaration.getAnnotation(clazz);
        if (a != null) {
            SourcePosition sourcePosition = interfaceDeclaration.getPosition();
            this.annotationError(sourcePosition, "webserviceap.invalid.sei.annotation", new Object[]{clazz.getName(), interfaceDeclaration.getQualifiedName()});
        }
    }

    protected void checkForInvalidImplAnnotation(Declaration declaration, Class clazz) {
        Object a = declaration.getAnnotation(clazz);
        if (a != null) {
            SourcePosition sourcePosition = declaration.getPosition();
            this.annotationError(sourcePosition, "webserviceap.endpointinteface.plus.annotation", clazz.getName());
        }
    }

    protected void annotationError(SourcePosition sourcePosition, String string, String string2) {
        this.annotationError(sourcePosition, string, new Object[]{string2});
    }

    protected void annotationError(SourcePosition sourcePosition, String string, Object[] objectArray) {
        this.builder.onError(sourcePosition, string, objectArray);
    }

    protected void preProcessWebService(WebService webService, TypeDeclaration typeDeclaration) {
        String string;
        this.seiContext = this.context.getSEIContext(typeDeclaration);
        String string2 = null;
        if (webService != null) {
            string2 = webService.targetNamespace();
        }
        if (string2 == null || string2.length() == 0) {
            string = typeDeclaration.getPackage().getQualifiedName();
            if (string == null || string.length() == 0) {
                this.builder.onError(typeDeclaration.getPosition(), "webserviceap.no.package.class.must.have.targetnamespace", new Object[]{typeDeclaration.getQualifiedName()});
            }
            string2 = this.getNamespace(typeDeclaration.getPackage());
        }
        this.seiContext.setNamespaceURI(string2);
        if (this.serviceImplName == null) {
            this.serviceImplName = this.seiContext.getSEIImplName();
        }
        if (this.serviceImplName != null) {
            this.seiContext.setSEIImplName(this.serviceImplName);
            this.context.addSEIContext(this.serviceImplName, this.seiContext);
        }
        this.portName = ClassNameInfo.getName(typeDeclaration.getSimpleName().replace('$', '_'));
        this.packageName = typeDeclaration.getPackage().getQualifiedName();
        this.portName = webService != null && webService.name() != null && webService.name().length() > 0 ? webService.name() : this.portName;
        this.serviceName = ClassNameInfo.getName(typeDeclaration.getQualifiedName()) + "Service";
        this.serviceName = webService != null && webService.serviceName() != null && webService.serviceName().length() > 0 ? webService.serviceName() : this.serviceName;
        this.typeNamespace = this.wsdlNamespace = this.seiContext.getNamespaceURI();
        string = typeDeclaration.getAnnotation(SOAPBinding.class);
        if (string != null) {
            this.pushedSOAPBinding = this.pushSOAPBinding((SOAPBinding)string, typeDeclaration, typeDeclaration);
        } else if (typeDeclaration.equals(this.typeDecl)) {
            this.pushedSOAPBinding = this.pushSOAPBinding(new MySOAPBinding(), typeDeclaration, typeDeclaration);
        }
    }

    public static boolean sameStyle(SOAPBinding.Style style, SOAPStyle sOAPStyle) {
        if (style.equals((Object)SOAPBinding.Style.DOCUMENT) && sOAPStyle.equals(SOAPStyle.DOCUMENT)) {
            return true;
        }
        return style.equals((Object)SOAPBinding.Style.RPC) && sOAPStyle.equals(SOAPStyle.RPC);
    }

    protected boolean pushSOAPBinding(SOAPBinding sOAPBinding, Declaration declaration, TypeDeclaration typeDeclaration) {
        boolean bl = false;
        if (!WebServiceVisitor.sameStyle(sOAPBinding.style(), this.soapStyle)) {
            bl = true;
            if (this.pushedSOAPBinding) {
                this.builder.onError(declaration.getPosition(), "webserviceap.mixed.binding.style", new Object[]{typeDeclaration.getQualifiedName()});
            }
        }
        if (sOAPBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
            this.soapStyle = SOAPStyle.RPC;
            this.wrapped = true;
            if (sOAPBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE)) {
                this.builder.onError(declaration.getPosition(), "webserviceap.rpc.literal.must.not.be.bare", new Object[]{typeDeclaration.getQualifiedName()});
            }
        } else {
            this.soapStyle = SOAPStyle.DOCUMENT;
            if (this.wrapped != sOAPBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED)) {
                this.wrapped = sOAPBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
                bl = true;
            }
        }
        if (sOAPBinding.use().equals((Object)SOAPBinding.Use.ENCODED)) {
            this.builder.onError(declaration.getPosition(), "webserviceap.rpc.encoded.not.supported", new Object[]{typeDeclaration.getQualifiedName()});
        }
        if (bl || this.soapBindingStack.empty()) {
            this.soapBindingStack.push(sOAPBinding);
            this.pushedSOAPBinding = true;
        }
        return bl;
    }

    protected SOAPBinding popSOAPBinding() {
        if (this.pushedSOAPBinding) {
            this.soapBindingStack.pop();
        }
        SOAPBinding sOAPBinding = null;
        if (!this.soapBindingStack.empty()) {
            sOAPBinding = this.soapBindingStack.peek();
            if (sOAPBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
                this.soapStyle = SOAPStyle.RPC;
                this.wrapped = true;
            } else {
                this.soapStyle = SOAPStyle.DOCUMENT;
                this.wrapped = sOAPBinding.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.WRAPPED);
            }
        }
        return sOAPBinding;
    }

    protected String getNamespace(PackageDeclaration packageDeclaration) {
        return RuntimeModeler.getNamespace((String)packageDeclaration.getQualifiedName());
    }

    protected boolean shouldProcessWebService(WebService webService, InterfaceDeclaration interfaceDeclaration) {
        this.hasWebMethods = false;
        if (webService == null) {
            this.builder.onError(interfaceDeclaration.getPosition(), "webserviceap.endpointinterface.has.no.webservice.annotation", new Object[]{interfaceDeclaration.getQualifiedName()});
        }
        return this.isLegalSEI(interfaceDeclaration);
    }

    protected boolean shouldProcessWebService(WebService webService, ClassDeclaration classDeclaration) {
        if (webService == null) {
            return false;
        }
        this.hasWebMethods = this.hasWebMethods(classDeclaration);
        return this.isLegalImplementation(webService, classDeclaration);
    }

    protected abstract void processWebService(WebService var1, TypeDeclaration var2);

    protected void postProcessWebService(WebService webService, InterfaceDeclaration interfaceDeclaration) {
        this.processMethods(interfaceDeclaration);
        this.popSOAPBinding();
    }

    protected void postProcessWebService(WebService webService, ClassDeclaration classDeclaration) {
        this.processMethods(classDeclaration);
        this.popSOAPBinding();
    }

    protected boolean hasWebMethods(ClassDeclaration classDeclaration) {
        if (classDeclaration.getQualifiedName().equals("java.lang.Object")) {
            return false;
        }
        for (MethodDeclaration methodDeclaration : classDeclaration.getMethods()) {
            WebMethod webMethod = methodDeclaration.getAnnotation(WebMethod.class);
            if (webMethod == null) continue;
            if (webMethod.exclude()) {
                if (webMethod.operationName().length() > 0) {
                    this.builder.onError(methodDeclaration.getPosition(), "webserviceap.invalid.webmethod.element.with.exclude", new Object[]{"operationName", classDeclaration.getQualifiedName(), methodDeclaration.toString()});
                }
                if (webMethod.action().length() <= 0) continue;
                this.builder.onError(methodDeclaration.getPosition(), "webserviceap.invalid.webmethod.element.with.exclude", new Object[]{"action", classDeclaration.getQualifiedName(), methodDeclaration.toString()});
                continue;
            }
            return true;
        }
        return false;
    }

    protected void processMethods(InterfaceDeclaration interfaceDeclaration) {
        this.builder.log("ProcessedMethods Interface: " + interfaceDeclaration);
        this.hasWebMethods = false;
        for (MethodDeclaration object : interfaceDeclaration.getMethods()) {
            object.accept(this);
        }
        for (InterfaceType interfaceType : interfaceDeclaration.getSuperinterfaces()) {
            this.processMethods(interfaceType.getDeclaration());
        }
    }

    protected void processMethods(ClassDeclaration classDeclaration) {
        this.builder.log("ProcessedMethods Class: " + classDeclaration);
        this.hasWebMethods = this.hasWebMethods(classDeclaration);
        if (classDeclaration.getQualifiedName().equals("java.lang.Object")) {
            return;
        }
        if (classDeclaration.getAnnotation(WebService.class) != null) {
            for (MethodDeclaration methodDeclaration : classDeclaration.getMethods()) {
                methodDeclaration.accept(this);
            }
        }
        if (classDeclaration.getSuperclass() != null) {
            this.processMethods(classDeclaration.getSuperclass().getDeclaration());
        }
    }

    private InterfaceDeclaration getEndpointInterfaceDecl(String string, ClassDeclaration classDeclaration) {
        InterfaceDeclaration interfaceDeclaration = null;
        for (InterfaceType interfaceType : classDeclaration.getSuperinterfaces()) {
            if (!string.equals(interfaceType.toString())) continue;
            interfaceDeclaration = interfaceType.getDeclaration();
            this.seiContext = this.context.getSEIContext(interfaceDeclaration.getQualifiedName());
            assert (this.seiContext != null);
            this.seiContext.setImplementsSEI(true);
            break;
        }
        if (interfaceDeclaration == null) {
            interfaceDeclaration = (InterfaceDeclaration)this.builder.getTypeDeclaration(string);
        }
        if (interfaceDeclaration == null) {
            this.builder.onError("webserviceap.endpointinterface.class.not.found", new Object[]{string});
        }
        return interfaceDeclaration;
    }

    private void inspectEndpointInterface(String string, ClassDeclaration classDeclaration) {
        InterfaceDeclaration interfaceDeclaration = this.getEndpointInterfaceDecl(string, classDeclaration);
        if (interfaceDeclaration != null) {
            interfaceDeclaration.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        if (!methodDeclaration.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return;
        }
        if (this.processedMethod(methodDeclaration)) {
            return;
        }
        WebMethod webMethod = methodDeclaration.getAnnotation(WebMethod.class);
        if (webMethod != null && webMethod.exclude()) {
            return;
        }
        SOAPBinding sOAPBinding = methodDeclaration.getAnnotation(SOAPBinding.class);
        if (sOAPBinding == null && !methodDeclaration.getDeclaringType().equals(this.typeDecl) && methodDeclaration.getDeclaringType() instanceof ClassDeclaration) {
            sOAPBinding = methodDeclaration.getDeclaringType().getAnnotation(SOAPBinding.class);
            if (sOAPBinding != null) {
                this.builder.log("using " + methodDeclaration.getDeclaringType() + "'s SOAPBinding.");
            } else {
                sOAPBinding = new MySOAPBinding();
            }
        }
        boolean bl = false;
        if (sOAPBinding != null) {
            bl = this.pushSOAPBinding(sOAPBinding, methodDeclaration, this.typeDecl);
        }
        try {
            if (this.shouldProcessMethod(methodDeclaration, webMethod)) {
                this.processMethod(methodDeclaration, webMethod);
            }
        }
        finally {
            if (bl) {
                this.popSOAPBinding();
            }
        }
    }

    protected boolean processedMethod(MethodDeclaration methodDeclaration) {
        String string = methodDeclaration.toString();
        if (this.processedMethods.contains(string)) {
            return true;
        }
        this.processedMethods.add(string);
        return false;
    }

    protected boolean shouldProcessMethod(MethodDeclaration methodDeclaration, WebMethod webMethod) {
        this.builder.log("should process method: " + methodDeclaration.getSimpleName() + " hasWebMethods: " + this.hasWebMethods + " ");
        if (this.hasWebMethods && webMethod == null) {
            this.builder.log("webMethod == null");
            return false;
        }
        boolean bl = this.endpointReferencesInterface || methodDeclaration.getDeclaringType().equals(this.typeDecl) || methodDeclaration.getDeclaringType().getAnnotation(WebService.class) != null;
        this.builder.log("endpointReferencesInterface: " + this.endpointReferencesInterface);
        this.builder.log("declaring class has WebSevice: " + (methodDeclaration.getDeclaringType().getAnnotation(WebService.class) != null));
        this.builder.log("returning: " + bl);
        return bl;
    }

    protected abstract void processMethod(MethodDeclaration var1, WebMethod var2);

    protected boolean isLegalImplementation(WebService webService, ClassDeclaration classDeclaration) {
        Collection<Modifier> collection = classDeclaration.getModifiers();
        if (!collection.contains((Object)Modifier.PUBLIC)) {
            this.builder.onError(classDeclaration.getPosition(), "webserviceap.webservice.class.not.public", new Object[]{classDeclaration.getQualifiedName()});
            return false;
        }
        if (collection.contains((Object)Modifier.FINAL)) {
            this.builder.onError(classDeclaration.getPosition(), "webserviceap.webservice.class.is.final", new Object[]{classDeclaration.getQualifiedName()});
            return false;
        }
        if (collection.contains((Object)Modifier.ABSTRACT)) {
            this.builder.onError(classDeclaration.getPosition(), "webserviceap.webservice.class.is.abstract", new Object[]{classDeclaration.getQualifiedName()});
            return false;
        }
        if (classDeclaration.getDeclaringType() != null && !collection.contains((Object)Modifier.STATIC)) {
            this.builder.onError(classDeclaration.getPosition(), "webserviceap.webservice.class.is.innerclass.not.static", new Object[]{classDeclaration.getQualifiedName()});
            return false;
        }
        boolean bl = false;
        Object object = classDeclaration.getConstructors().iterator();
        while (object.hasNext()) {
            ConstructorDeclaration constructorDeclaration = object.next();
            if (!constructorDeclaration.getModifiers().contains((Object)Modifier.PUBLIC) || constructorDeclaration.getParameters().size() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.builder.onError(classDeclaration.getPosition(), "webserviceap.webservice.no.default.constructor", new Object[]{classDeclaration.getQualifiedName()});
            return false;
        }
        return !(webService.endpointInterface().length() == 0 ? !this.methodsAreLegal(classDeclaration) : !this.classImplementsSEI(classDeclaration, (InterfaceDeclaration)(object = this.getEndpointInterfaceDecl(webService.endpointInterface(), classDeclaration))));
    }

    protected boolean classImplementsSEI(ClassDeclaration classDeclaration, InterfaceDeclaration interfaceDeclaration) {
        for (InterfaceType object : classDeclaration.getSuperinterfaces()) {
            if (!object.getDeclaration().equals(interfaceDeclaration)) continue;
            return true;
        }
        for (MethodDeclaration methodDeclaration : interfaceDeclaration.getMethods()) {
            boolean bl = false;
            for (MethodDeclaration methodDeclaration2 : classDeclaration.getMethods()) {
                if (!this.sameMethod(methodDeclaration, methodDeclaration2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.method.not.implemented", new Object[]{interfaceDeclaration.getSimpleName(), classDeclaration.getSimpleName(), methodDeclaration});
            return false;
        }
        return true;
    }

    protected boolean sameMethod(MethodDeclaration methodDeclaration, MethodDeclaration methodDeclaration2) {
        ParameterDeclaration[] parameterDeclarationArray;
        if (!methodDeclaration.getSimpleName().equals(methodDeclaration2.getSimpleName())) {
            return false;
        }
        if (!((Object)methodDeclaration.getReturnType()).equals(methodDeclaration2.getReturnType())) {
            return false;
        }
        ParameterDeclaration[] parameterDeclarationArray2 = methodDeclaration.getParameters().toArray(new ParameterDeclaration[0]);
        if (parameterDeclarationArray2.length != (parameterDeclarationArray = methodDeclaration2.getParameters().toArray(new ParameterDeclaration[0])).length) {
            return false;
        }
        int n = 0;
        for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
            if (((Object)parameterDeclaration.getType()).equals(parameterDeclarationArray[n++].getType())) continue;
            return false;
        }
        return true;
    }

    protected boolean isLegalSEI(InterfaceDeclaration interfaceDeclaration) {
        for (FieldDeclaration fieldDeclaration : interfaceDeclaration.getFields()) {
            if (fieldDeclaration.getConstantValue() == null) continue;
            this.builder.onError("webserviceap.sei.cannot.contain.constant.values", new Object[]{interfaceDeclaration.getQualifiedName(), fieldDeclaration.getSimpleName()});
            return false;
        }
        return this.methodsAreLegal(interfaceDeclaration);
    }

    protected boolean methodsAreLegal(InterfaceDeclaration interfaceDeclaration) {
        this.hasWebMethods = false;
        for (MethodDeclaration object : interfaceDeclaration.getMethods()) {
            if (this.isLegalMethod(object, interfaceDeclaration)) continue;
            return false;
        }
        for (InterfaceType interfaceType : interfaceDeclaration.getSuperinterfaces()) {
            if (this.methodsAreLegal(interfaceType.getDeclaration())) continue;
            return false;
        }
        return true;
    }

    protected boolean methodsAreLegal(ClassDeclaration classDeclaration) {
        this.hasWebMethods = this.hasWebMethods(classDeclaration);
        for (MethodDeclaration methodDeclaration : classDeclaration.getMethods()) {
            if (this.isLegalMethod(methodDeclaration, classDeclaration)) continue;
            return false;
        }
        ClassType classType = classDeclaration.getSuperclass();
        return classType == null || this.methodsAreLegal(classType.getDeclaration());
    }

    protected boolean isLegalMethod(MethodDeclaration methodDeclaration, TypeDeclaration typeDeclaration) {
        boolean bl;
        if (this.hasWebMethods && methodDeclaration.getAnnotation(WebMethod.class) == null) {
            return true;
        }
        if (typeDeclaration instanceof ClassDeclaration && methodDeclaration.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.webservice.method.is.abstract", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.getSimpleName()});
            return false;
        }
        if (!this.isLegalType(methodDeclaration.getReturnType())) {
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.method.return.type.cannot.implement.remote", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.getSimpleName(), methodDeclaration.getReturnType()});
        }
        boolean bl2 = bl = methodDeclaration.getAnnotation(Oneway.class) != null;
        if (bl && !this.isValidOnewayMethod(methodDeclaration, typeDeclaration)) {
            return false;
        }
        SOAPBinding sOAPBinding = methodDeclaration.getAnnotation(SOAPBinding.class);
        if (sOAPBinding != null && sOAPBinding.style().equals((Object)SOAPBinding.Style.RPC)) {
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.rpc.soapbinding.not.allowed.on.method", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
        }
        int n = 0;
        for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
            if (this.isLegalParameter(parameterDeclaration, methodDeclaration, typeDeclaration, n++)) continue;
            return false;
        }
        if (!this.isDocLitWrapped() && this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            ParameterDeclaration parameterDeclaration = this.getOutParameter(methodDeclaration);
            int n2 = this.getModeParameterCount(methodDeclaration, WebParam.Mode.IN);
            int n3 = this.getModeParameterCount(methodDeclaration, WebParam.Mode.OUT);
            if (n2 != 1) {
                this.builder.onError(methodDeclaration.getPosition(), "webserviceap.doc.bare.and.no.one.in", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
            }
            if (methodDeclaration.getReturnType() instanceof VoidType) {
                if (parameterDeclaration == null && !bl) {
                    this.builder.onError(methodDeclaration.getPosition(), "webserviceap.doc.bare.no.out", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
                }
                if (n3 != 1 && !bl && n3 != 0) {
                    this.builder.onError(methodDeclaration.getPosition(), "webserviceap.doc.bare.no.return.and.no.out", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
                }
            } else if (n3 > 0) {
                this.builder.onError(parameterDeclaration.getPosition(), "webserviceap.doc.bare.return.and.out", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
            }
        }
        return true;
    }

    protected boolean isLegalParameter(ParameterDeclaration parameterDeclaration, MethodDeclaration methodDeclaration, TypeDeclaration typeDeclaration, int n) {
        if (!this.isLegalType(parameterDeclaration.getType())) {
            this.builder.onError(parameterDeclaration.getPosition(), "webserviceap.method.parameter.types.cannot.implement.remote", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.getSimpleName(), parameterDeclaration.getSimpleName(), ((Object)parameterDeclaration.getType()).toString()});
            return false;
        }
        TypeMirror typeMirror = this.builder.getHolderValueType(parameterDeclaration.getType());
        WebParam webParam = parameterDeclaration.getAnnotation(WebParam.class);
        WebParam.Mode mode = null;
        if (webParam != null) {
            mode = webParam.mode();
        }
        if (typeMirror != null) {
            if (mode != null && mode.equals((Object)WebParam.Mode.IN)) {
                this.builder.onError(parameterDeclaration.getPosition(), "webserviceap.holder.parameters.must.not.be.in.only", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString(), n});
            }
        } else if (mode != null && !mode.equals((Object)WebParam.Mode.IN)) {
            this.builder.onError(parameterDeclaration.getPosition(), "webserviceap.non.in.parameters.must.be.holder", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString(), n});
        }
        return true;
    }

    protected boolean isDocLitWrapped() {
        return this.soapStyle.equals(SOAPStyle.DOCUMENT) && this.wrapped;
    }

    protected boolean isValidOnewayMethod(MethodDeclaration methodDeclaration, TypeDeclaration typeDeclaration) {
        int n;
        ParameterDeclaration parameterDeclaration;
        boolean bl = true;
        if (!(methodDeclaration.getReturnType() instanceof VoidType)) {
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.oneway.operation.cannot.have.return.type", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
            bl = false;
        }
        if ((parameterDeclaration = this.getOutParameter(methodDeclaration)) != null) {
            this.builder.onError(parameterDeclaration.getPosition(), "webserviceap.oneway.and.out", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
            bl = false;
        }
        if (!this.isDocLitWrapped() && this.soapStyle.equals(SOAPStyle.DOCUMENT) && (n = this.getModeParameterCount(methodDeclaration, WebParam.Mode.IN)) != 1) {
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.oneway.and.not.one.in", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString()});
            bl = false;
        }
        for (ReferenceType referenceType : methodDeclaration.getThrownTypes()) {
            ClassDeclaration classDeclaration = ((ClassType)referenceType).getDeclaration();
            if (this.builder.isRemoteException(classDeclaration)) continue;
            this.builder.onError(methodDeclaration.getPosition(), "webserviceap.oneway.operation.cannot.declare.exceptions", new Object[]{typeDeclaration.getQualifiedName(), methodDeclaration.toString(), classDeclaration.getQualifiedName()});
            bl = false;
        }
        return bl;
    }

    protected int getModeParameterCount(MethodDeclaration methodDeclaration, WebParam.Mode mode) {
        int n = 0;
        for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
            WebParam webParam = parameterDeclaration.getAnnotation(WebParam.class);
            if (webParam != null) {
                if (webParam.header() || !this.isEquivalentModes(mode, webParam.mode())) continue;
                ++n;
                continue;
            }
            if (!this.isEquivalentModes(mode, WebParam.Mode.IN)) continue;
            ++n;
        }
        return n;
    }

    protected boolean isEquivalentModes(WebParam.Mode mode, WebParam.Mode mode2) {
        if (mode.equals((Object)mode2)) {
            return true;
        }
        assert (mode.equals((Object)WebParam.Mode.IN) || mode.equals((Object)WebParam.Mode.OUT));
        if (mode.equals((Object)WebParam.Mode.IN) && !mode2.equals((Object)WebParam.Mode.OUT)) {
            return true;
        }
        return mode.equals((Object)WebParam.Mode.OUT) && !mode2.equals((Object)WebParam.Mode.IN);
    }

    protected boolean isHolder(ParameterDeclaration parameterDeclaration) {
        return this.builder.getHolderValueType(parameterDeclaration.getType()) != null;
    }

    protected boolean isLegalType(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return true;
        }
        return !this.builder.isRemote(((DeclaredType)typeMirror).getDeclaration());
    }

    public void addSchemaElements(MethodDeclaration methodDeclaration, boolean bl) {
        this.addReturnSchemaElement(methodDeclaration, bl);
        boolean bl2 = false;
        for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
            bl2 |= this.addParamSchemaElement(parameterDeclaration, methodDeclaration, bl);
        }
        if (!bl2 && this.soapStyle.equals(SOAPStyle.DOCUMENT) && !bl) {
            QName qName = new QName(this.wsdlNamespace, methodDeclaration.getSimpleName());
            this.seiContext.addSchemaElement(qName, null);
        }
    }

    public void addReturnSchemaElement(MethodDeclaration methodDeclaration, boolean bl) {
        TypeMirror typeMirror = methodDeclaration.getReturnType();
        WebResult webResult = methodDeclaration.getAnnotation(WebResult.class);
        String string = this.builder.getResponseName(methodDeclaration.getSimpleName());
        String string2 = this.wsdlNamespace;
        boolean bl2 = false;
        if (webResult != null) {
            string = webResult.name().length() > 0 ? webResult.name() : string;
            string2 = webResult.targetNamespace().length() > 0 ? webResult.targetNamespace() : string2;
            bl2 = webResult.header();
        }
        QName qName = new QName(string2, string);
        if (!(typeMirror instanceof VoidType || bl && !bl2)) {
            Reference reference = this.seiContext.addReference(methodDeclaration);
            if (!this.soapStyle.equals(SOAPStyle.RPC)) {
                this.seiContext.addSchemaElement(qName, reference);
            }
        }
    }

    public boolean addParamSchemaElement(ParameterDeclaration parameterDeclaration, MethodDeclaration methodDeclaration, boolean bl) {
        boolean bl2 = false;
        WebParam webParam = parameterDeclaration.getAnnotation(WebParam.class);
        String string = parameterDeclaration.getSimpleName();
        String string2 = this.wsdlNamespace;
        TypeMirror typeMirror = parameterDeclaration.getType();
        TypeMirror typeMirror2 = this.builder.getHolderValueType(typeMirror);
        boolean bl3 = false;
        if (this.soapStyle.equals(SOAPStyle.DOCUMENT) && !this.wrapped) {
            string = methodDeclaration.getSimpleName();
        }
        if (webParam != null) {
            string = webParam.name() != null && webParam.name().length() > 0 ? webParam.name() : string;
            bl3 = webParam.header();
            String string3 = string2 = webParam.targetNamespace().length() > 0 ? webParam.targetNamespace() : string2;
        }
        if (typeMirror2 != null) {
            typeMirror = typeMirror2;
        }
        if (bl3 || this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            if (bl3 || !bl) {
                QName qName = new QName(string2, string);
                Reference reference = this.seiContext.addReference(typeMirror, parameterDeclaration);
                this.seiContext.addSchemaElement(qName, reference);
            }
        } else {
            this.seiContext.addReference(typeMirror, parameterDeclaration);
        }
        if (!(bl3 || typeMirror2 != null && webParam != null && webParam.mode().equals((Object)WebParam.Mode.OUT))) {
            bl2 = true;
        }
        return bl2;
    }

    protected ParameterDeclaration getOutParameter(MethodDeclaration methodDeclaration) {
        for (ParameterDeclaration parameterDeclaration : methodDeclaration.getParameters()) {
            WebParam webParam = parameterDeclaration.getAnnotation(WebParam.class);
            if (webParam == null || webParam.mode().equals((Object)WebParam.Mode.IN)) continue;
            return parameterDeclaration;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MySOAPBinding
    implements SOAPBinding {
        protected MySOAPBinding() {
        }

        public SOAPBinding.Style style() {
            return SOAPBinding.Style.DOCUMENT;
        }

        public SOAPBinding.Use use() {
            return SOAPBinding.Use.LITERAL;
        }

        public SOAPBinding.ParameterStyle parameterStyle() {
            return SOAPBinding.ParameterStyle.WRAPPED;
        }

        public Class<? extends Annotation> annotationType() {
            return SOAPBinding.class;
        }
    }
}

