/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.writer;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassContainer;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JType;
import com.sun.tools.internal.xjc.outline.ClassOutline;
import com.sun.tools.internal.xjc.outline.FieldOutline;
import com.sun.tools.internal.xjc.outline.Outline;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class SignatureWriter {
    private final Collection<? extends ClassOutline> classes;
    private final Map<JDefinedClass, ClassOutline> classSet = new HashMap<JDefinedClass, ClassOutline>();
    private final Writer out;
    private int indent = 0;

    public static void write(Outline outline, Writer writer) throws IOException {
        new SignatureWriter(outline, writer).dump();
    }

    private SignatureWriter(Outline outline, Writer writer) {
        this.out = writer;
        this.classes = outline.getClasses();
        for (ClassOutline classOutline : this.classes) {
            this.classSet.put(classOutline.ref, classOutline);
        }
    }

    private void printIndent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write("  ");
        }
    }

    private void println(String string) throws IOException {
        this.printIndent();
        this.out.write(string);
        this.out.write(10);
    }

    private void dump() throws IOException {
        TreeSet<JPackage> treeSet = new TreeSet<JPackage>(new Comparator<JPackage>(){

            @Override
            public int compare(JPackage jPackage, JPackage jPackage2) {
                return jPackage.name().compareTo(jPackage2.name());
            }
        });
        for (ClassOutline object : this.classes) {
            treeSet.add(object._package()._package());
        }
        for (JPackage jPackage : treeSet) {
            this.dump(jPackage);
        }
        this.out.flush();
    }

    private void dump(JPackage jPackage) throws IOException {
        this.println("package " + jPackage.name() + " {");
        ++this.indent;
        this.dumpChildren(jPackage);
        --this.indent;
        this.println("}");
    }

    private void dumpChildren(JClassContainer jClassContainer) throws IOException {
        Iterator<JDefinedClass> iterator = jClassContainer.classes();
        while (iterator.hasNext()) {
            JDefinedClass jDefinedClass = iterator.next();
            ClassOutline classOutline = this.classSet.get(jDefinedClass);
            if (classOutline == null) continue;
            this.dump(classOutline);
        }
    }

    private void dump(ClassOutline classOutline) throws IOException {
        JDefinedClass jDefinedClass = classOutline.implClass;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("interface ");
        stringBuilder.append(jDefinedClass.name());
        boolean bl = true;
        Iterator<JClass> iterator = jDefinedClass._implements();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuilder.append(" extends ");
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.printName(iterator.next()));
        }
        stringBuilder.append(" {");
        this.println(stringBuilder.toString());
        ++this.indent;
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            String string = this.printName(fieldOutline.getRawType());
            this.println(string + ' ' + fieldOutline.getPropertyInfo().getName(true) + ';');
        }
        this.dumpChildren(jDefinedClass);
        --this.indent;
        this.println("}");
    }

    private String printName(JType jType) {
        String string = jType.fullName();
        if (string.startsWith("java.lang.")) {
            string = string.substring(10);
        }
        return string;
    }
}

