/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.BaseLineInfo;
import com.sun.tools.jdi.ConcreteMethodImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.LineInfo;
import com.sun.tools.jdi.NonConcreteMethodImpl;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.SDE;
import com.sun.tools.jdi.StratumLineInfo;
import com.sun.tools.jdi.TypeComponentImpl;
import com.sun.tools.jdi.ValueContainer;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodImpl
extends TypeComponentImpl
implements Method {
    private JNITypeParser signatureParser;
    ReturnContainer retValContainer = null;

    abstract int argSlotCount() throws AbsentInformationException;

    abstract List<Location> allLineLocations(SDE.Stratum var1, String var2) throws AbsentInformationException;

    abstract List<Location> locationsOfLine(SDE.Stratum var1, String var2, int var3) throws AbsentInformationException;

    MethodImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l, String string, String string2, String string3, int n) {
        super(virtualMachine, referenceTypeImpl, l, string, string2, string3, n);
        this.signatureParser = new JNITypeParser(string2);
    }

    static MethodImpl createMethodImpl(VirtualMachine virtualMachine, ReferenceTypeImpl referenceTypeImpl, long l, String string, String string2, String string3, int n) {
        if ((n & 0x500) != 0) {
            return new NonConcreteMethodImpl(virtualMachine, referenceTypeImpl, l, string, string2, string3, n);
        }
        return new ConcreteMethodImpl(virtualMachine, referenceTypeImpl, l, string, string2, string3, n);
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof MethodImpl) {
            MethodImpl methodImpl = (MethodImpl)object;
            return ((Object)this.declaringType()).equals(methodImpl.declaringType()) && this.ref() == methodImpl.ref() && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.ref();
    }

    @Override
    public final List<Location> allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    @Override
    public List<Location> allLineLocations(String string, String string2) throws AbsentInformationException {
        return this.allLineLocations(this.declaringType.stratum(string), string2);
    }

    @Override
    public final List<Location> locationsOfLine(int n) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, n);
    }

    @Override
    public List<Location> locationsOfLine(String string, String string2, int n) throws AbsentInformationException {
        return this.locationsOfLine(this.declaringType.stratum(string), string2, n);
    }

    LineInfo codeIndexToLineInfo(SDE.Stratum stratum, long l) {
        if (stratum.isJava()) {
            return new BaseLineInfo(-1, this.declaringType);
        }
        return new StratumLineInfo(stratum.id(), -1, null, null);
    }

    @Override
    public String returnTypeName() {
        return this.signatureParser.typeName();
    }

    private String returnSignature() {
        return this.signatureParser.signature();
    }

    @Override
    public Type returnType() throws ClassNotLoadedException {
        return this.findType(this.returnSignature());
    }

    public Type findType(String string) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        return referenceTypeImpl.findType(string);
    }

    @Override
    public List<String> argumentTypeNames() {
        return this.signatureParser.argumentTypeNames();
    }

    public List<String> argumentSignatures() {
        return this.signatureParser.argumentSignatures();
    }

    Type argumentType(int n) throws ClassNotLoadedException {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        String string = this.argumentSignatures().get(n);
        return referenceTypeImpl.findType(string);
    }

    @Override
    public List<Type> argumentTypes() throws ClassNotLoadedException {
        int n = this.argumentSignatures().size();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        for (int i = 0; i < n; ++i) {
            Type type = this.argumentType(i);
            arrayList.add(type);
        }
        return arrayList;
    }

    @Override
    public int compareTo(Method method) {
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)this.declaringType();
        int n = referenceTypeImpl.compareTo(method.declaringType());
        if (n == 0) {
            n = referenceTypeImpl.indexOf(this) - referenceTypeImpl.indexOf(method);
        }
        return n;
    }

    @Override
    public boolean isAbstract() {
        return this.isModifierSet(1024);
    }

    @Override
    public boolean isSynchronized() {
        return this.isModifierSet(32);
    }

    @Override
    public boolean isNative() {
        return this.isModifierSet(256);
    }

    @Override
    public boolean isVarArgs() {
        return this.isModifierSet(128);
    }

    @Override
    public boolean isBridge() {
        return this.isModifierSet(64);
    }

    @Override
    public boolean isConstructor() {
        return this.name().equals("<init>");
    }

    @Override
    public boolean isStaticInitializer() {
        return this.name().equals("<clinit>");
    }

    @Override
    public boolean isObsolete() {
        try {
            return JDWP.Method.IsObsolete.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this.declaringType, (long)this.ref).isObsolete;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    ReturnContainer getReturnValueContainer() {
        if (this.retValContainer == null) {
            this.retValContainer = new ReturnContainer();
        }
        return this.retValContainer;
    }

    void handleVarArgs(List<Value> list) throws ClassNotLoadedException, InvalidTypeException {
        int n;
        List<Type> list2 = this.argumentTypes();
        ArrayType arrayType = (ArrayType)list2.get(list2.size() - 1);
        Type type = arrayType.componentType();
        int n2 = list.size();
        if (n2 < (n = list2.size()) - 1) {
            return;
        }
        if (n2 == n - 1) {
            ArrayReference arrayReference = arrayType.newInstance(0);
            list.add(arrayReference);
            return;
        }
        Value value = list.get(n - 1);
        if (value == null) {
            return;
        }
        Type type2 = value.type();
        if (type2 instanceof ArrayTypeImpl && n2 == n && ((ArrayTypeImpl)type2).isAssignableTo(arrayType)) {
            return;
        }
        int n3 = n2 - n + 1;
        ArrayReference arrayReference = arrayType.newInstance(n3);
        arrayReference.setValues(0, list, n - 1, n3);
        list.set(n - 1, arrayReference);
        for (int i = n; i < n2; ++i) {
            list.remove(n);
        }
    }

    List<Value> validateAndPrepareArgumentsForInvoke(List<? extends Value> list) throws ClassNotLoadedException, InvalidTypeException {
        ArrayList<Value> arrayList = new ArrayList<Value>(list);
        if (this.isVarArgs()) {
            this.handleVarArgs(arrayList);
        }
        int n = arrayList.size();
        JNITypeParser jNITypeParser = new JNITypeParser(this.signature());
        List<String> list2 = jNITypeParser.argumentSignatures();
        if (list2.size() != n) {
            throw new IllegalArgumentException("Invalid argument count: expected " + list2.size() + ", received " + arrayList.size());
        }
        for (int i = 0; i < n; ++i) {
            Value value = (Value)arrayList.get(i);
            value = ValueImpl.prepareForAssignment(value, new ArgumentContainer(i));
            arrayList.set(i, value);
        }
        return arrayList;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.declaringType().name());
        stringBuffer.append(".");
        stringBuffer.append(this.name());
        stringBuffer.append("(");
        boolean bl = true;
        for (String string : this.argumentTypeNames()) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            bl = false;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    class ArgumentContainer
    implements ValueContainer {
        int index;

        ArgumentContainer(int n) {
            this.index = n;
        }

        public Type type() throws ClassNotLoadedException {
            return MethodImpl.this.argumentType(this.index);
        }

        public String typeName() {
            return MethodImpl.this.argumentTypeNames().get(this.index);
        }

        public String signature() {
            return MethodImpl.this.argumentSignatures().get(this.index);
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return MethodImpl.this.findType(string);
        }
    }

    class ReturnContainer
    implements ValueContainer {
        ReturnContainer() {
        }

        public Type type() throws ClassNotLoadedException {
            return MethodImpl.this.returnType();
        }

        public String typeName() {
            return MethodImpl.this.returnTypeName();
        }

        public String signature() {
            return MethodImpl.this.returnSignature();
        }

        public Type findType(String string) throws ClassNotLoadedException {
            return MethodImpl.this.findType(string);
        }
    }
}

