/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.parser;

import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.impl.parser.NGCCRuntimeEx;
import com.sun.xml.internal.xsom.impl.parser.ParserContext;
import com.sun.xml.internal.xsom.impl.parser.state.Schema;
import com.sun.xml.internal.xsom.parser.AnnotationParser;
import com.sun.xml.internal.xsom.parser.AnnotationParserFactory;
import com.sun.xml.internal.xsom.parser.JAXPParser;
import com.sun.xml.internal.xsom.parser.SchemaDocument;
import com.sun.xml.internal.xsom.parser.XMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSOMParser {
    private EntityResolver entityResolver;
    private ErrorHandler userErrorHandler;
    private AnnotationParserFactory apFactory;
    private final ParserContext context;

    public XSOMParser() {
        this(new JAXPParser());
    }

    public XSOMParser(SAXParserFactory sAXParserFactory) {
        this(new JAXPParser(sAXParserFactory));
    }

    public XSOMParser(XMLParser xMLParser) {
        this.context = new ParserContext(this, xMLParser);
    }

    public void parse(InputStream inputStream) throws SAXException {
        this.parse(new InputSource(inputStream));
    }

    public void parse(Reader reader) throws SAXException {
        this.parse(new InputSource(reader));
    }

    public void parse(File file) throws SAXException, IOException {
        this.parse(file.toURL());
    }

    public void parse(URL uRL) throws SAXException {
        this.parse(uRL.toExternalForm());
    }

    public void parse(String string) throws SAXException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws SAXException {
        this.context.parse(inputSource);
    }

    public ContentHandler getParserHandler() {
        NGCCRuntimeEx nGCCRuntimeEx = this.context.newNGCCRuntime();
        Schema schema = new Schema(nGCCRuntimeEx, false, null);
        nGCCRuntimeEx.setRootHandler(schema);
        return nGCCRuntimeEx;
    }

    public XSSchemaSet getResult() throws SAXException {
        return this.context.getResult();
    }

    public Set<SchemaDocument> getDocuments() {
        return new HashSet<SchemaDocument>(this.context.parsedDocuments.keySet());
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.userErrorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.userErrorHandler = errorHandler;
    }

    public void setAnnotationParser(final Class clazz) {
        this.setAnnotationParser(new AnnotationParserFactory(){

            public AnnotationParser create() {
                try {
                    return (AnnotationParser)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new InstantiationError(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalAccessError(illegalAccessException.getMessage());
                }
            }
        });
    }

    public void setAnnotationParser(AnnotationParserFactory annotationParserFactory) {
        this.apFactory = annotationParserFactory;
    }

    public AnnotationParserFactory getAnnotationParserFactory() {
        return this.apFactory;
    }
}

