/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.Parser;
import sun.tools.jstat.ParserException;

public class OptionLister {
    private static final boolean debug = false;
    private URL[] sources;

    public OptionLister(URL[] uRLArray) {
        this.sources = uRLArray;
    }

    public void print(PrintStream printStream) {
        Comparator<OptionFormat> comparator = new Comparator<OptionFormat>(){

            @Override
            public int compare(OptionFormat optionFormat, OptionFormat optionFormat2) {
                OptionFormat optionFormat3 = optionFormat;
                OptionFormat optionFormat4 = optionFormat2;
                return optionFormat3.getName().compareTo(optionFormat4.getName());
            }
        };
        TreeSet<OptionFormat> treeSet = new TreeSet<OptionFormat>(comparator);
        for (int i = 0; i < this.sources.length; ++i) {
            try {
                URL iOException = this.sources[i];
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iOException.openStream()));
                Set<OptionFormat> set = new Parser(bufferedReader).parseOptions();
                treeSet.addAll(set);
                continue;
            }
            catch (IOException parserException) {
                continue;
            }
            catch (ParserException parserException) {
                System.err.println(this.sources[i] + ": " + parserException.getMessage());
                System.err.println("Parsing of " + this.sources[i] + " aborted");
            }
        }
        for (OptionFormat optionFormat : treeSet) {
            if (optionFormat.getName().compareTo("timestamp") == 0) continue;
            printStream.println("-" + optionFormat.getName());
        }
    }
}

