/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demo.scripting.jconsole;

import com.sun.demo.scripting.jconsole.ScriptShellPanel;
import com.sun.tools.jconsole.JConsolePlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptJConsolePlugin
extends JConsolePlugin
implements ScriptShellPanel.CommandProcessor {
    private volatile ScriptShellPanel window;
    private Map<String, JPanel> tabs;
    private volatile ScriptEngine engine;
    private CountDownLatch engineReady = new CountDownLatch(1);
    private String extension;
    private volatile String prompt;
    private static final String LANGUAGE_KEY = "com.sun.demo.jconsole.console.language";

    @Override
    public Map<String, JPanel> getTabs() {
        this.createScriptEngine();
        this.window = new ScriptShellPanel(this);
        this.tabs = new HashMap<String, JPanel>();
        this.tabs.put("Script Shell", this.window);
        new Thread(new Runnable(){

            public void run() {
                ScriptJConsolePlugin.this.initScriptEngine();
                ScriptJConsolePlugin.this.engineReady.countDown();
            }
        }).start();
        return this.tabs;
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return null;
    }

    @Override
    public void dispose() {
        this.window.dispose();
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public String executeCommand(String string) {
        String string2;
        try {
            this.engineReady.await();
            Object object = this.engine.eval(string);
            string2 = object == null ? null : object.toString();
        }
        catch (InterruptedException interruptedException) {
            string2 = interruptedException.getMessage();
        }
        catch (ScriptException scriptException) {
            string2 = scriptException.getMessage();
        }
        return string2;
    }

    private void createScriptEngine() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        String string = this.getScriptLanguage();
        this.engine = scriptEngineManager.getEngineByName(string);
        if (this.engine == null) {
            throw new RuntimeException("cannot load " + string + " engine");
        }
        this.extension = this.engine.getFactory().getExtensions().get(0);
        this.prompt = this.extension + ">";
        this.engine.setBindings(this.createBindings(), 100);
    }

    private String getScriptLanguage() {
        String string = System.getProperty(LANGUAGE_KEY);
        if (string == null) {
            string = "JavaScript";
        }
        return string;
    }

    private Bindings createBindings() {
        Map<String, Object> map = Collections.synchronizedMap(new HashMap());
        return new SimpleBindings(map);
    }

    private void initScriptEngine() {
        this.setGlobals();
        this.loadInitFile();
        this.loadUserInitFile();
    }

    private void setGlobals() {
        this.engine.put("engine", this.engine);
        this.engine.put("window", this.window);
        this.engine.put("plugin", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitFile() {
        String string = (String)this.engine.get("javax.script.filename");
        this.engine.put("javax.script.filename", "<built-in jconsole." + this.extension + ">");
        try {
            Class<?> clazz = this.getClass();
            InputStream inputStream = clazz.getResourceAsStream("/resources/jconsole." + this.extension);
            if (inputStream != null) {
                this.engine.eval(new InputStreamReader(new BufferedInputStream(inputStream)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.engine.put("javax.script.filename", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserInitFile() {
        String string = (String)this.engine.get("javax.script.filename");
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return;
        }
        String string3 = string2 + File.separator + "jconsole." + this.extension;
        if (!new File(string3).exists()) {
            return;
        }
        this.engine.put("javax.script.filename", string3);
        try {
            this.engine.eval(new FileReader(string3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.engine.put("javax.script.filename", string);
        }
    }
}

