/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.helper.C14nHelper;
import com.sun.org.apache.xml.internal.security.c14n.implementations.CanonicalizerBase;
import com.sun.org.apache.xml.internal.security.c14n.implementations.NameSpaceSymbTable;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Canonicalizer11
extends CanonicalizerBase {
    boolean firstCall = true;
    final SortedSet result = new TreeSet(COMPARE);
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    static Logger log = Logger.getLogger(Canonicalizer11.class.getName());
    XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer11(boolean bl) {
        super(bl);
    }

    Iterator handleAttributesSubtree(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNamespaceURI();
            if (XMLNS_URI != string) {
                sortedSet.add(attr);
                continue;
            }
            String string2 = attr.getLocalName();
            String string3 = attr.getValue();
            if ("xml".equals(string2) && XML_LANG_URI.equals(string3) || (node = nameSpaceSymbTable.addMappingAndRender(string2, string3, attr)) == null) continue;
            sortedSet.add(node);
            if (!C14nHelper.namespaceIsRelative(attr)) continue;
            Object[] objectArray = new Object[]{element.getTagName(), string2, attr.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    Iterator handleAttributes(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Node node;
        this.xmlattrStack.push(nameSpaceSymbTable.getLevel());
        boolean bl = this.isVisibleDO(element, nameSpaceSymbTable.getLevel()) == 1;
        NamedNodeMap namedNodeMap = null;
        int n = 0;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n = namedNodeMap.getLength();
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        for (int i = 0; i < n; ++i) {
            node = (Attr)namedNodeMap.item(i);
            String string = node.getNamespaceURI();
            if (XMLNS_URI != string) {
                if (XML_LANG_URI == string) {
                    if (node.getLocalName().equals("id")) {
                        if (!bl) continue;
                        sortedSet.add(node);
                        continue;
                    }
                    this.xmlattrStack.addXmlnsAttr((Attr)node);
                    continue;
                }
                if (!bl) continue;
                sortedSet.add(node);
                continue;
            }
            String string2 = node.getLocalName();
            String string3 = node.getValue();
            if ("xml".equals(string2) && XML_LANG_URI.equals(string3)) continue;
            if (this.isVisible(node)) {
                Node node2;
                if (!bl && nameSpaceSymbTable.removeMappingIfRender(string2) || (node2 = nameSpaceSymbTable.addMappingAndRender(string2, string3, (Attr)node)) == null) continue;
                sortedSet.add(node2);
                if (!C14nHelper.namespaceIsRelative((Attr)node)) continue;
                Object[] objectArray = new Object[]{element.getTagName(), string2, node.getNodeValue()};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
            if (bl && string2 != "xmlns") {
                nameSpaceSymbTable.removeMapping(string2);
                continue;
            }
            nameSpaceSymbTable.addMapping(string2, string3, (Attr)node);
        }
        if (bl) {
            Attr attr = element.getAttributeNodeNS(XMLNS_URI, "xmlns");
            node = null;
            if (attr == null) {
                node = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible(attr)) {
                node = nameSpaceSymbTable.addMappingAndRender("xmlns", "", nullNode);
            }
            if (node != null) {
                sortedSet.add(node);
            }
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
        }
        return sortedSet.iterator();
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    void circumventBugIfNeeded(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!xMLSignatureInput.isNeedsToBeExpanded()) {
            return;
        }
        Document document = null;
        document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
        XMLUtils.circumventBug2650(document);
    }

    void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        if (!element.hasAttributes()) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (XMLNS_URI != attr.getNamespaceURI()) {
                if (XML_LANG_URI != attr.getNamespaceURI()) continue;
                this.xmlattrStack.addXmlnsAttr(attr);
                continue;
            }
            String string = attr.getLocalName();
            String string2 = attr.getNodeValue();
            if ("xml".equals(string) && XML_LANG_URI.equals(string2)) continue;
            nameSpaceSymbTable.addMapping(string, string2, attr);
        }
    }

    private static String joinURI(String string, String string2) throws URISyntaxException {
        String string3;
        String string4;
        String string5;
        String string6;
        URI uRI;
        String string7 = null;
        String string8 = null;
        String string9 = "";
        String string10 = null;
        String string11 = null;
        if (string != null) {
            if (string.endsWith("..")) {
                string = string + "/";
            }
            uRI = new URI(string);
            string7 = uRI.getScheme();
            string8 = uRI.getAuthority();
            string9 = uRI.getPath();
            string10 = uRI.getQuery();
            string11 = uRI.getFragment();
        }
        uRI = new URI(string2);
        String string12 = uRI.getScheme();
        String string13 = uRI.getAuthority();
        String string14 = uRI.getPath();
        String string15 = uRI.getQuery();
        String string16 = null;
        if (string12 != null && string12.equals(string7)) {
            string12 = null;
        }
        if (string12 != null) {
            string6 = string12;
            string5 = string13;
            string4 = Canonicalizer11.removeDotSegments(string14);
            string3 = string15;
        } else {
            if (string13 != null) {
                string5 = string13;
                string4 = Canonicalizer11.removeDotSegments(string14);
                string3 = string15;
            } else {
                if (string14.length() == 0) {
                    string4 = string9;
                    string3 = string15 != null ? string15 : string10;
                } else {
                    if (string14.startsWith("/")) {
                        string4 = Canonicalizer11.removeDotSegments(string14);
                    } else {
                        int n;
                        string4 = string8 != null && string9.length() == 0 ? "/" + string14 : ((n = string9.lastIndexOf(47)) == -1 ? string14 : string9.substring(0, n + 1) + string14);
                        string4 = Canonicalizer11.removeDotSegments(string4);
                    }
                    string3 = string15;
                }
                string5 = string8;
            }
            string6 = string7;
        }
        String string17 = string16;
        return new URI(string6, string5, string4, string3, string17).toString();
    }

    private static String removeDotSegments(String string) {
        log.log(Level.FINE, "STEP   OUTPUT BUFFER\t\tINPUT BUFFER");
        String string2 = string;
        while (string2.indexOf("//") > -1) {
            string2 = string2.replaceAll("//", "/");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.charAt(0) == '/') {
            stringBuffer.append("/");
            string2 = string2.substring(1);
        }
        Canonicalizer11.printStep("1 ", stringBuffer.toString(), string2);
        while (string2.length() != 0) {
            String string3;
            int n;
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
                Canonicalizer11.printStep("2A", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.startsWith("../")) {
                string2 = string2.substring(3);
                if (!stringBuffer.toString().equals("/")) {
                    stringBuffer.append("../");
                }
                Canonicalizer11.printStep("2A", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.startsWith("/./")) {
                string2 = string2.substring(2);
                Canonicalizer11.printStep("2B", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.equals("/.")) {
                string2 = string2.replaceFirst("/.", "/");
                Canonicalizer11.printStep("2B", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.startsWith("/../")) {
                string2 = string2.substring(3);
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("/");
                } else if (stringBuffer.toString().endsWith("../")) {
                    stringBuffer.append("..");
                } else if (stringBuffer.toString().endsWith("..")) {
                    stringBuffer.append("/..");
                } else {
                    n = stringBuffer.lastIndexOf("/");
                    if (n == -1) {
                        stringBuffer = new StringBuffer();
                        if (string2.charAt(0) == '/') {
                            string2 = string2.substring(1);
                        }
                    } else {
                        stringBuffer = stringBuffer.delete(n, stringBuffer.length());
                    }
                }
                Canonicalizer11.printStep("2C", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.equals("/..")) {
                string2 = string2.replaceFirst("/..", "/");
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("/");
                } else if (stringBuffer.toString().endsWith("../")) {
                    stringBuffer.append("..");
                } else if (stringBuffer.toString().endsWith("..")) {
                    stringBuffer.append("/..");
                } else {
                    n = stringBuffer.lastIndexOf("/");
                    if (n == -1) {
                        stringBuffer = new StringBuffer();
                        if (string2.charAt(0) == '/') {
                            string2 = string2.substring(1);
                        }
                    } else {
                        stringBuffer = stringBuffer.delete(n, stringBuffer.length());
                    }
                }
                Canonicalizer11.printStep("2C", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.equals(".")) {
                string2 = "";
                Canonicalizer11.printStep("2D", stringBuffer.toString(), string2);
                continue;
            }
            if (string2.equals("..")) {
                if (!stringBuffer.toString().equals("/")) {
                    stringBuffer.append("..");
                }
                string2 = "";
                Canonicalizer11.printStep("2D", stringBuffer.toString(), string2);
                continue;
            }
            n = -1;
            int n2 = string2.indexOf(47);
            if (n2 == 0) {
                n = string2.indexOf(47, 1);
            } else {
                n = n2;
                n2 = 0;
            }
            if (n == -1) {
                string3 = string2.substring(n2);
                string2 = "";
            } else {
                string3 = string2.substring(n2, n);
                string2 = string2.substring(n);
            }
            stringBuffer.append(string3);
            Canonicalizer11.printStep("2E", stringBuffer.toString(), string2);
        }
        if (stringBuffer.toString().endsWith("..")) {
            stringBuffer.append("/");
            Canonicalizer11.printStep("3 ", stringBuffer.toString(), string2);
        }
        return stringBuffer.toString();
    }

    private static void printStep(String string, String string2, String string3) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " " + string + ":   " + string2);
            if (string2.length() == 0) {
                log.log(Level.FINE, "\t\t\t\t" + string3);
            } else {
                log.log(Level.FINE, "\t\t\t" + string3);
            }
        }
    }

    static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List levels = new ArrayList();

        XmlAttrStack() {
        }

        void push(int n) {
            this.currentLevel = n;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel >= this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                if (this.levels.size() == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = ((XmlsStackElement)this.levels.get((int)(this.levels.size() - 1))).level;
            }
        }

        void addXmlnsAttr(Attr attr) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(attr);
        }

        void getXmlnsAttr(Collection collection) {
            Object object;
            Iterator iterator;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            int n = this.levels.size() - 2;
            boolean bl = false;
            XmlsStackElement xmlsStackElement = null;
            if (n == -1) {
                bl = true;
            } else {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                    bl = true;
                }
            }
            if (bl) {
                collection.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl2 = true;
            while (n >= 0) {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                if (xmlsStackElement.rendered) {
                    bl2 = false;
                }
                iterator = xmlsStackElement.nodes.iterator();
                while (iterator.hasNext() && bl2) {
                    object = (Attr)iterator.next();
                    if (object.getLocalName().equals("base")) {
                        if (xmlsStackElement.rendered) continue;
                        arrayList.add(object);
                        continue;
                    }
                    if (hashMap.containsKey(object.getName())) continue;
                    hashMap.put(object.getName(), object);
                }
                --n;
            }
            if (!arrayList.isEmpty()) {
                iterator = this.cur.nodes.iterator();
                object = null;
                Attr attr = null;
                while (iterator.hasNext()) {
                    Attr attr2 = (Attr)iterator.next();
                    if (!attr2.getLocalName().equals("base")) continue;
                    object = attr2.getValue();
                    attr = attr2;
                    break;
                }
                for (Attr attr2 : arrayList) {
                    if (object == null) {
                        object = attr2.getValue();
                        attr = attr2;
                        continue;
                    }
                    try {
                        object = Canonicalizer11.joinURI(attr2.getValue(), (String)object);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                }
                if (object != null && ((String)object).length() != 0) {
                    attr.setValue((String)object);
                    collection.add(attr);
                }
            }
            this.cur.rendered = true;
            collection.addAll(hashMap.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List nodes = new ArrayList();

            XmlsStackElement() {
            }
        }
    }
}

