/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.transport.http.server.HttpEndpoint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServicePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object actualEndpoint;
    private Executor executor;
    private boolean published;
    private boolean stopped;
    private final com.sun.xml.internal.ws.spi.runtime.Binding binding;
    private final Object implementor;
    private Map<String, Object> properties;
    private List<Source> metadata;

    public EndpointImpl(String string, Object object) {
        this.implementor = object;
        this.binding = BindingImpl.getBinding(string, object.getClass(), null, false);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void publish(String string) {
        URL uRL;
        this.canPublish();
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot create URL for this address " + string);
        }
        if (!uRL.getProtocol().equals("http")) {
            throw new IllegalArgumentException(uRL.getProtocol() + " protocol based address is not supported");
        }
        if (!uRL.getPath().startsWith("/")) {
            throw new IllegalArgumentException("Incorrect WebService address=" + string + ". The address's path should start with /");
        }
        this.checkPlatform();
        this.actualEndpoint = new HttpEndpoint(this.implementor, this.binding, this.metadata, this.properties, this.executor);
        ((HttpEndpoint)this.actualEndpoint).publish(string);
        this.published = true;
    }

    @Override
    public void publish(Object object) {
        this.canPublish();
        this.checkPlatform();
        if (!HttpContext.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(object.getClass() + " is not a supported context.");
        }
        this.actualEndpoint = new HttpEndpoint(this.implementor, this.binding, this.metadata, this.properties, this.executor);
        ((HttpEndpoint)this.actualEndpoint).publish(object);
        this.published = true;
    }

    @Override
    public void stop() {
        if (this.published) {
            ((HttpEndpoint)this.actualEndpoint).stop();
            this.published = false;
            this.stopped = true;
        }
    }

    @Override
    public boolean isPublished() {
        return this.published;
    }

    private void canPublish() {
        if (this.published) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already published.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already stopped.");
        }
    }

    @Override
    public List<Source> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(List<Source> list) {
        if (this.published) {
            throw new IllegalStateException("Cannot set Metadata. Endpoint is already published");
        }
        this.metadata = list;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    private void checkPlatform() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
        }
        try {
            Class.forName("com.sun.net.httpserver.HttpServer");
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("NOT SUPPORTED");
        }
    }
}

