/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

class XWINProtocol
extends XProtocol
implements XStateProtocol,
XLayerProtocol {
    static final Logger log = Logger.getLogger("sun.awt.X11.XWINProtocol");
    XAtom XA_WIN_SUPPORTING_WM_CHECK = XAtom.get("_WIN_SUPPORTING_WM_CHECK");
    XAtom XA_WIN_PROTOCOLS = XAtom.get("_WIN_PROTOCOLS");
    XAtom XA_WIN_STATE = XAtom.get("_WIN_STATE");
    XAtom XA_WIN_LAYER = XAtom.get("_WIN_LAYER");
    static final int WIN_STATE_STICKY = 1;
    static final int WIN_STATE_MINIMIZED = 2;
    static final int WIN_STATE_MAXIMIZED_VERT = 4;
    static final int WIN_STATE_MAXIMIZED_HORIZ = 8;
    static final int WIN_STATE_HIDDEN = 16;
    static final int WIN_STATE_SHADED = 32;
    static final int WIN_LAYER_ONTOP = 6;
    static final int WIN_LAYER_NORMAL = 4;
    long WinWindow = 0L;
    boolean supportChecked = false;

    XWINProtocol() {
    }

    public boolean supportsState(int n) {
        return this.doStateProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(XWindowPeer xWindowPeer, int n) {
        if (xWindowPeer.isShowing()) {
            long l = 0L;
            if ((n & 4) != 0) {
                l |= 4L;
            }
            if ((n & 2) != 0) {
                l |= 8L;
            }
            XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(xWindowPeer.getWindow());
            xClientMessageEvent.set_message_type(this.XA_WIN_STATE.getAtom());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_data(0, 12L);
            xClientMessageEvent.set_data(1, l);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Sending WIN_STATE to root to change the state to " + l);
            }
            try {
                XToolkit.awtLock();
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 0x180000L, xClientMessageEvent.pData);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            xClientMessageEvent.dispose();
        } else {
            long l;
            long l2 = l = this.XA_WIN_STATE.getCard32Property(xWindowPeer);
            l = (n & 1) != 0 ? (l |= 2L) : (l &= 0xFFFFFFFFFFFFFFFDL);
            l = (n & 4) != 0 ? (l |= 4L) : (l &= 0xFFFFFFFFFFFFFFFBL);
            l = (n & 2) != 0 ? (l |= 8L) : (l &= 0xFFFFFFFFFFFFFFF7L);
            if ((l2 ^ l) != 0L) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Setting WIN_STATE on " + xWindowPeer + " to change the state to " + l);
                }
                this.XA_WIN_STATE.setCard32Property(xWindowPeer, l);
            }
        }
    }

    public int getState(XWindowPeer xWindowPeer) {
        long l = this.XA_WIN_STATE.getCard32Property(xWindowPeer);
        int n = 0;
        if ((l & 4L) != 0L) {
            n |= 4;
        }
        if ((l & 8L) != 0L) {
            n |= 2;
        }
        return n;
    }

    public boolean isStateChange(XPropertyEvent xPropertyEvent) {
        return this.doStateProtocol() && xPropertyEvent.get_atom() == this.XA_WIN_STATE.getAtom();
    }

    public void unshadeKludge(XWindowPeer xWindowPeer) {
        long l = this.XA_WIN_STATE.getCard32Property(xWindowPeer);
        if ((l & 0x20L) == 0L) {
            return;
        }
        this.XA_WIN_STATE.setCard32Property(xWindowPeer, l &= 0xFFFFFFFFFFFFFFDFL);
    }

    public boolean supportsLayer(int n) {
        return (n == 1 || n == 0) && this.doLayerProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayer(XWindowPeer xWindowPeer, int n) {
        if (xWindowPeer.isShowing()) {
            XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(xWindowPeer.getWindow());
            xClientMessageEvent.set_message_type(this.XA_WIN_LAYER.getAtom());
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_data(0, n == 0 ? 4L : 6L);
            xClientMessageEvent.set_data(1, 0L);
            xClientMessageEvent.set_data(2, 0L);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting layer " + n + " by root message : " + xClientMessageEvent);
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), xWindowPeer.getScreenNumber()), false, 524288L, xClientMessageEvent.pData);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            xClientMessageEvent.dispose();
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting layer property to " + n);
            }
            this.XA_WIN_LAYER.setCard32Property(xWindowPeer, n == 0 ? 4L : 6L);
        }
    }

    void detect() {
        if (this.supportChecked) {
            return;
        }
        this.WinWindow = this.checkAnchor(this.XA_WIN_SUPPORTING_WM_CHECK, 6L);
        this.supportChecked = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " is active: " + (this.WinWindow != 0L));
        }
    }

    boolean active() {
        this.detect();
        return this.WinWindow != 0L;
    }

    boolean doStateProtocol() {
        boolean bl;
        boolean bl2 = bl = this.active() && this.checkProtocol(this.XA_WIN_PROTOCOLS, this.XA_WIN_STATE);
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " supports state: " + bl);
        }
        return bl;
    }

    boolean doLayerProtocol() {
        boolean bl;
        boolean bl2 = bl = this.active() && this.checkProtocol(this.XA_WIN_PROTOCOLS, this.XA_WIN_LAYER);
        if (log.isLoggable(Level.FINE)) {
            log.fine("### " + this + " supports layer: " + bl);
        }
        return bl;
    }
}

